#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 
#define SCREEN_HEIGHT 32 

#define OLED_RESET     -1 
#define SCREEN_ADDRESS 0x3C ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);


// 'logo', 128x32px
const unsigned char logo [] PROGMEM = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0xfd, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x67, 0xc6, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0x07, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xe0, 0x27, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xe6, 0x67, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xe6, 0x67, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xe6, 0x67, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0x47, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x6f, 0xc6, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0xfd, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

void drawArrowUp(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawFastVLine(x0 + i, y0 + size - i, 2 * i + 1, color);
  }
}

void drawArrowDown(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawFastHLine(x0 - i, y0 - i, 2 * i + 1, color);
  }
}   

void setup() 
{
  Serial.begin(9600);
  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }
  display.display();
  delay(2000); 
  display.clearDisplay();
}

void loop() 
{
  display.drawBitmap(0, 0, logo, 128, 32, WHITE);
  
  display.display();
  delay(15000);
  display.clearDisplay(); // Wyczyść cały ekran
  display.display(); 

  // Rysujemy dwie proste linie
  int x1 = SCREEN_WIDTH / 3; // x końca pierwszej linii (1/3 szerokości)
  int y1 = SCREEN_HEIGHT * 2 / 3; // y końca pierwszej linii (2/3 wysokości)

  // Pierwsza linia z strzałkami na końcach
  display.drawLine(0, y1, SCREEN_WIDTH, y1, WHITE); 
  display.drawLine(x1 - 5, 5, x1, 0, WHITE); // górna strzałka 
  display.drawLine(x1 + 5, 5, x1, 0, WHITE); // górna strzałka 
  display.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, WHITE); // dolna strzałka
  display.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, WHITE); // dolna strzałka


  // Druga linia z strzałkami na końcach
  display.drawLine(x1, SCREEN_HEIGHT, x1, 0, WHITE);  // druga linia
  display.drawLine(SCREEN_WIDTH - 6, y1 - 5, SCREEN_WIDTH - 1, y1, WHITE); // Prawa strzałka
  display.drawLine(SCREEN_WIDTH - 6, y1 + 5, SCREEN_WIDTH - 1, y1, WHITE); // Prawa strzałka
  display.drawLine(5, y1 - 5, 0, y1, WHITE); // lewa strzałka
  display.drawLine(5, y1 + 5, 0, y1, WHITE); // lewa strzałka

  // Napis "32px" nad lewą strzałką pierwszej linii
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(45, 8);
  display.print("32px");

  // Napis "128px" po prawej stronie drugiej linii
  display.setCursor(91, 12);
  display.print("128px");

  display.display();

  delay(15000);
  display.clearDisplay(); 
  display.display(); 
}

