#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

#define OLED_RESET -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

const unsigned char logo [] PROGMEM = {
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc3, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x99, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0f, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7e, 0x78, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0x9e, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xff, 0xe7, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xff, 0xf3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x9f, 
	0xff, 0xf9, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x31, 0xfe, 0x1c, 0xf0, 0x00, 0x00, 0x00, 0x00, 
	0x1e, 0x60, 0xc0, 0x0e, 0x78, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xe0, 0x00, 0x0f, 0x3c, 0x00, 0x00, 
	0x00, 0x00, 0x39, 0xe0, 0x01, 0x0f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x73, 0xf0, 0xc3, 0x8f, 0xce, 
	0x00, 0x00, 0x00, 0x00, 0xe7, 0xf0, 0xc3, 0x8f, 0xe7, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf0, 0xc3, 
	0x8f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf0, 0xc3, 0x8f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0xe7, 
	0xf0, 0xc3, 0x8f, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x73, 0xf0, 0xc3, 0x8f, 0xce, 0x00, 0x00, 0x00, 
	0x00, 0x79, 0xf0, 0xc7, 0x8f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0xc7, 0x0f, 0x3c, 0x00, 
	0x00, 0x00, 0x00, 0x1e, 0x71, 0xc7, 0x1e, 0x78, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3f, 0xff, 0xfc, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x9f, 0xff, 0xf9, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xcf, 
	0xff, 0xf3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xff, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xf3, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0x9e, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x3c, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7e, 0x78, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x99, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x01, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00
};

void setup() 
{
  Serial.begin(9600);
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) 
  {
    Serial.println(F("SSD1306 allocation failed"));
    for(;;);
  }

  display.display();
  delay(2000); 
  display.clearDisplay(); 
}

void loop() 
{
  display.drawBitmap(28, 24, logo, 72, 40, WHITE);
  display.display();

  delay(15000);
  display.clearDisplay(); 
  display.display(); 

  // Rysujemy dwie proste linie
  int x1 = SCREEN_WIDTH / 3 + 5; // x końca pierwszej linii (1/3 szerokości)
  int y1 = SCREEN_HEIGHT * 2 / 3; // y końca pierwszej linii (2/3 wysokości)

  // Pierwsza linia z strzałkami na końcach
  display.drawLine(0, y1, SCREEN_WIDTH, y1, WHITE); 
  display.drawLine(x1 - 5, 5+16, x1, 0+16, WHITE); // górna strzałka 
  display.drawLine(x1 + 5, 5+16, x1, 0+16, WHITE); // górna strzałka 
  display.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, WHITE); // dolna strzałka
  display.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, WHITE); // dolna strzałka

  // Druga linia z strzałkami na końcach
  display.drawLine(x1, SCREEN_HEIGHT, x1, 0, WHITE);  // druga linia
  display.drawLine(SCREEN_WIDTH - 6 - 32, y1 - 5, SCREEN_WIDTH - 1-32, y1, WHITE); // Prawa strzałka
  display.drawLine(SCREEN_WIDTH - 6 - 32, y1 + 5, SCREEN_WIDTH - 1-32, y1, WHITE); // Prawa strzałka
  display.drawLine(5+32, y1 - 5, 32, y1, WHITE); // lewa strzałka
  display.drawLine(5+32, y1 + 5, 32, y1, WHITE); // lewa strzałka

  // Napis "48px" nad lewą strzałką pierwszej linii
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(49, 24);
  display.print("48px");

  // Napis "64px" po prawej stronie drugiej linii
  display.setCursor(65, 44);
  display.print("64px");
  display.display();

  delay(15000);
  display.clearDisplay(); 
  display.display(); 
}