#include <Wire.h>
#include <Adafruit_SSD1327.h>
#include <Adafruit_GFX.h>

#define OLED_RESET -1
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 96

Adafruit_SSD1327 display(128, 96, &Wire, OLED_RESET, 1000000);  // deklaracja klasy wyswietlacza

// 'logo_128x96', 128x96px
const unsigned char logo [] PROGMEM = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x07, 0xe0, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xbf, 0xfd, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0xfe, 0x7f, 0xe0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x07, 0xfc, 0x3f, 0xc0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x19, 0x8f, 0xf8, 0x1f, 0xe1, 0x98, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcf, 0xf1, 0x8f, 0xf3, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7f, 0xe3, 0xc7, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7f, 0xc7, 0xe3, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x8f, 0xf1, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x03, 0x81, 0xff, 0x1f, 0xf8, 0xff, 0x81, 0xc0, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x06, 0xc3, 0xfe, 0x3f, 0xfc, 0x7f, 0xc3, 0x60, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x04, 0x67, 0xfc, 0x7f, 0xfe, 0x3f, 0xe6, 0x20, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x06, 0x3f, 0xf8, 0xff, 0xff, 0x1f, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x03, 0x1f, 0xf1, 0xff, 0xff, 0x8f, 0xf8, 0xc0, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x01, 0xbf, 0xe3, 0xff, 0xff, 0xc7, 0xfd, 0x80, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x80, 0xff, 0xc7, 0xff, 0xff, 0xe3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x01, 0xe0, 0xff, 0x8f, 0xff, 0xff, 0xf1, 0xff, 0x07, 0x80, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x03, 0x31, 0xff, 0x1f, 0xff, 0xff, 0xf8, 0xff, 0x8c, 0xc0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x03, 0x1b, 0xfe, 0x3f, 0xff, 0xff, 0xfc, 0x7f, 0xd8, 0xc0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x01, 0x8f, 0xfc, 0x7f, 0xff, 0xff, 0xfe, 0x3f, 0xf1, 0x80, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0xcf, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf3, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x6f, 0xf1, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xfe, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x70, 0x3f, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xfc, 0x0e, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0xf8, 0x7f, 0xc7, 0xff, 0xff, 0xff, 0x07, 0xe3, 0xfe, 0x1b, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x8c, 0xff, 0x8f, 0x80, 0xff, 0xfc, 0x03, 0xf1, 0xff, 0x31, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0xc6, 0xff, 0x1e, 0x00, 0xff, 0xf8, 0x01, 0xf8, 0xff, 0xe3, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x43, 0xfe, 0x3e, 0x00, 0xe0, 0x70, 0x01, 0xfc, 0x7f, 0xc6, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x33, 0xfc, 0x7e, 0x00, 0xc0, 0x20, 0x00, 0xfe, 0x3f, 0xcc, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xf8, 0xfe, 0x00, 0x80, 0x00, 0x00, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x0f, 0xf1, 0xfe, 0x00, 0x00, 0x07, 0x00, 0xff, 0x8f, 0xf0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xe3, 0xfe, 0x00, 0x00, 0x07, 0x00, 0xff, 0xc7, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xc7, 0xff, 0x00, 0x20, 0x0f, 0x00, 0xff, 0xe3, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0x8f, 0xff, 0x00, 0x70, 0x0f, 0x00, 0xff, 0xf1, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3f, 0x1f, 0xff, 0x00, 0xf0, 0x0f, 0x00, 0xff, 0xf8, 0xfc, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3e, 0x3f, 0xff, 0x00, 0xf0, 0x0f, 0x00, 0xff, 0xfc, 0x7c, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3c, 0x3f, 0xff, 0x00, 0xf0, 0x0f, 0x00, 0xff, 0xfe, 0x3c, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3c, 0x3f, 0xff, 0x00, 0xf0, 0x1f, 0x00, 0xff, 0xfe, 0x3c, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3e, 0x1f, 0xff, 0x00, 0xf0, 0x1f, 0x00, 0xff, 0xfc, 0x7c, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x3f, 0x0f, 0xff, 0x00, 0xf0, 0x1e, 0x01, 0xff, 0xf8, 0xfc, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0x87, 0xff, 0x00, 0xf0, 0x1e, 0x01, 0xff, 0xf1, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xc3, 0xff, 0x00, 0xf0, 0x1e, 0x01, 0xff, 0xe3, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xe1, 0xff, 0x00, 0xe0, 0x1e, 0x01, 0xff, 0xc7, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x0f, 0xf0, 0xff, 0x80, 0xe0, 0x1e, 0x01, 0xff, 0x8f, 0xf0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x1f, 0xf8, 0x7f, 0x81, 0xe0, 0x1e, 0x01, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x33, 0xfc, 0x3f, 0x81, 0xe0, 0x1c, 0x03, 0xfe, 0x3f, 0xec, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x63, 0xfe, 0x1f, 0x81, 0xe0, 0x3c, 0x03, 0xfc, 0x7f, 0xc2, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0xc7, 0xff, 0x0f, 0x81, 0xf8, 0x3c, 0x03, 0xf8, 0xff, 0xe3, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x8c, 0xff, 0x87, 0xff, 0xff, 0xfc, 0x03, 0xf1, 0xff, 0x31, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0xf8, 0x7f, 0xc3, 0xff, 0xff, 0xfc, 0x03, 0xe3, 0xfe, 0x1b, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x70, 0x3f, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xfc, 0x0e, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xf6, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0xcf, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0x1f, 0xe3, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x01, 0x8f, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x3f, 0xf1, 0x80, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x03, 0x19, 0xfe, 0x1f, 0xff, 0xff, 0xfc, 0x7f, 0x98, 0xc0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x03, 0x30, 0xff, 0x0f, 0xff, 0xff, 0xf8, 0xff, 0x0c, 0xc0, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x01, 0xe0, 0xff, 0x87, 0xff, 0xff, 0xf1, 0xff, 0x07, 0x80, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc3, 0xff, 0xff, 0xe3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x01, 0x9f, 0xe1, 0xff, 0xff, 0xc7, 0xf9, 0x80, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x03, 0x1f, 0xf0, 0xff, 0xff, 0x8f, 0xf8, 0xc0, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x06, 0x3f, 0xf8, 0x7f, 0xff, 0x1f, 0xec, 0x60, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x04, 0x67, 0xfc, 0x3f, 0xfe, 0x3f, 0xc6, 0x20, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x06, 0xc1, 0xfe, 0x1f, 0xfc, 0x7f, 0x83, 0x60, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x03, 0x81, 0xff, 0x0f, 0xf8, 0xff, 0x81, 0xc0, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x87, 0xf1, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7f, 0xc3, 0xe3, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7f, 0xe1, 0xc7, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcf, 0xf0, 0x0f, 0xf3, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x19, 0x87, 0xf8, 0x1f, 0xe1, 0x98, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x07, 0xfc, 0x3f, 0xc0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0xfe, 0x7f, 0xe0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xbf, 0xfd, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x07, 0xe0, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};



void setup() {
  Serial.begin(115200);

  if ( ! display.begin(0x3C) ) {  // inicjalizacja wyswietlacza na adresie 0x3C
     Serial.println("Unable to initialize OLED");
     for (;;);  // petla bez konca
  }
  display.clearDisplay();
  display.display();
  delay(2000);
}

void loop() 
{
  display.drawBitmap(0, 0, logo, 128, 96, SSD1327_WHITE);
  display.display();
  delay(15000);
  display.clearDisplay();
  
  // Rysujemy dwie proste linie
  int x1 = SCREEN_WIDTH / 3; // x końca pierwszej linii (1/3 szerokości)
  int y1 = SCREEN_HEIGHT * 2 / 3; // y końca pierwszej linii (2/3 wysokości)

  // Pierwsza linia z strzałkami na końcach
  display.drawLine(0, y1, SCREEN_WIDTH, y1, SSD1327_WHITE); 
  display.drawLine(x1 - 5, 5, x1, 0, SSD1327_WHITE); // górna strzałka 
  display.drawLine(x1 + 5, 5, x1, 0, SSD1327_WHITE); // górna strzałka 
  display.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, SSD1327_WHITE); // dolna strzałka
  display.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, SSD1327_WHITE); // dolna strzałka

  // Druga linia z strzałkami na końcach
  display.drawLine(x1, SCREEN_HEIGHT, x1, 0, SSD1327_WHITE);  // druga linia
  display.drawLine(SCREEN_WIDTH - 6, y1 - 5, SCREEN_WIDTH - 1, y1, SSD1327_WHITE); // Prawa strzałka
  display.drawLine(SCREEN_WIDTH - 6, y1 + 5, SCREEN_WIDTH - 1, y1, SSD1327_WHITE); // Prawa strzałka
  display.drawLine(5, y1 - 5, 0, y1, SSD1327_WHITE); // lewa strzałka
  display.drawLine(5, y1 + 5, 0, y1, SSD1327_WHITE); // lewa strzałka

  // Napis "96px" nad lewą strzałką pierwszej linii
  display.setTextSize(1);
  display.setTextColor(SSD1327_WHITE);
  display.setCursor(44, 8);
  display.print("96px");

  // Napis "128px" po prawej stronie drugiej linii
  display.setCursor(92, 55);
  display.print("128px");

  display.display();

  delay(15000);
  display.clearDisplay(); 
  display.display(); 
}
