#include <Wire.h>
#include <Adafruit_SH110X.h>  // wymagane biblioteki

/*
Podlaczenie do ESP32:
VCC -> 3.3V
GND -> GND
SCK -> gpio 22(SCL)
SDA -> gpio 21(SDA)
*/

#define i2c_Address 0x3c  // adres i2c wyswietlacza

#define SCREEN_WIDTH 128  // rozdzielczosc wyswietlacza
#define SCREEN_HEIGHT 64
#define OLED_RESET -1  // wyswietlacz bez pinu reset

// 'logo', 128x64px
const unsigned char logo [] PROGMEM = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2f, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0xbf, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0xdf, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xef, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xf7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xfb, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xfd, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfe, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xff, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xbf, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0xdf, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xef, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xf7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0xfb, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x98, 0x1f, 0xf0, 0x7d, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x38, 0x18, 0x60, 0x3e, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x78, 0x10, 0x00, 0x3f, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xf8, 0x00, 0x08, 0x1f, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xf8, 0x00, 0x18, 0x1f, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xf8, 0x18, 0x18, 0x1f, 0xef, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x18, 0x38, 0x1f, 0xf7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xf3, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x38, 0x38, 0x3f, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xfc, 0x38, 0x38, 0x3f, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xfc, 0x38, 0x38, 0x3f, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x38, 0x30, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x7c, 0x38, 0x30, 0x3e, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x3c, 0x38, 0x70, 0x7c, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x9d, 0xff, 0xf0, 0x79, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0x73, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xe7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xcf, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0x9f, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0x3f, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xfe, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfc, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xf9, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xf3, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xe7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xcf, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0x9f, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0x3f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x27, 0xf4, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

Adafruit_SH1106G display = Adafruit_SH1106G(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);  // definicja wyswietlacza 

void drawArrowUp(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawFastVLine(x0 + i, y0 + size - i, 2 * i + 1, color);
  }
}

void drawArrowDown(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawFastHLine(x0 - i, y0 - i, 2 * i + 1, color);
  }
}   

void setup() 
{
  Serial.begin(9600);
  delay(250);
  display.begin(i2c_Address, true);
  display.display();
  delay(2000);
  display.clearDisplay();
}

void loop() 
{
  display.drawBitmap(0, 0, logo, 128, 64, SH110X_WHITE);

  drawArrowUp(5, 4, 5, SH110X_WHITE); 
  display.setTextSize(1);
  display.setTextColor(SH110X_WHITE);
  display.setCursor(12, 6);
  display.print("64px");

  drawArrowDown(9, 58, 5, SH110X_WHITE); 
  display.setTextSize(1);
  display.setTextColor(SH110X_WHITE);
  display.setCursor(15, 52); 
  display.print("128px");
  
  display.display();
  delay(15000);
  display.clearDisplay(); // Wyczyść cały ekran
  display.display(); 

  // Rysujemy dwie proste linie
  int x1 = SCREEN_WIDTH / 3; // x końca pierwszej linii (1/3 szerokości)
  int y1 = SCREEN_HEIGHT * 2 / 3; // y końca pierwszej linii (2/3 wysokości)

  // Pierwsza linia z strzałkami na końcach
  display.drawLine(0, y1, SCREEN_WIDTH, y1, SH110X_WHITE); 
  display.drawLine(x1 - 5, 5, x1, 0, SH110X_WHITE); // górna strzałka 
  display.drawLine(x1 + 5, 5, x1, 0, SH110X_WHITE); // górna strzałka 
  display.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, SH110X_WHITE); // dolna strzałka
  display.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1, SH110X_WHITE); // dolna strzałka


  // Druga linia z strzałkami na końcach
  display.drawLine(x1, SCREEN_HEIGHT, x1, 0, SH110X_WHITE);  // druga linia
  display.drawLine(SCREEN_WIDTH - 6, y1 - 5, SCREEN_WIDTH - 1, y1, SH110X_WHITE); // Prawa strzałka
  display.drawLine(SCREEN_WIDTH - 6, y1 + 5, SCREEN_WIDTH - 1, y1, SH110X_WHITE); // Prawa strzałka
  display.drawLine(5, y1 - 5, 0, y1, SH110X_WHITE); // lewa strzałka
  display.drawLine(5, y1 + 5, 0, y1, SH110X_WHITE); // lewa strzałka

  // Napis "64px" nad lewą strzałką pierwszej linii
  display.setTextSize(1);
  display.setTextColor(SH110X_WHITE);
  display.setCursor(44, 8);
  display.print("64px");

  // Napis "128px" po prawej stronie drugiej linii
  display.setCursor(92, 34);
  display.print("128px");

  display.display();

  delay(15000);
  display.clearDisplay(); 
  display.display(); 
}
