#include <Wire.h>
#include <Adafruit_SH110X.h>  // wymagane biblioteki

/*
Podlaczenie do ESP32:
VCC -> 3.3V
GND -> GND
SCK -> gpio 22(SCL)
SDA -> gpio 21(SDA)
*/

#define i2c_Address 0x3c  // adres i2c wyswietlacza

#define SCREEN_WIDTH 128  // rozdzielczosc wyswietlacza
#define SCREEN_HEIGHT 64
#define OLED_RESET -1  // wyswietlacz bez pinu reset

Adafruit_SH1106G display = Adafruit_SH1106G(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);  // definicja wyswietlacza

void setup() {
  Serial.begin(9600);
  delay(250);
  display.begin(i2c_Address, true);  // inicjacja wyswietlacza
  display.display();  // wyswietlenie bufora (wymagane przy uruchomieniu skryptu)
  delay(2000);
  display.clearDisplay();  // wyczyszczenie bufora wyswietlacza
  display.setTextSize(1);  // ustawienie rozmiaru tekstu
  display.setTextColor(SH110X_WHITE);  // wybor koloru (biały/czarny)
  display.setCursor(24,22);  // pozycjonowanie kursora do pisania
  display.println("Tutorial OLED");  // wypisywany tekst
  display.setCursor(31,34);  // pozycjonowanie kursora do pisania
  display.println("msalamon.pl");  // druga linijka tekstu
  display.display();  // wyswietlenie bufora z tekstem
}

void loop() {
  // pusto
}
