#include <Wire.h>
#include <Adafruit_SH110X.h>  // wymagane biblioteki

/*
Podlaczenie do Arduino:
VCC -> 5V
GND -> GND
SCK -> A5(SCL)
SDA -> A4(SDA)
*/

#define i2c_Address 0x3c  // adres i2c wyswietlacza

#define SCREEN_WIDTH 128  // rozdzielczosc wyswietlacza
#define SCREEN_HEIGHT 64
#define OLED_RESET -1  // wyswietlacz bez pinu reset

// 'logo', 128x64px
const unsigned char logo [] PROGMEM = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2f, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0xbf, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0xdf, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xef, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xf7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xfb, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xfd, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfe, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xff, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xbf, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0xdf, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xef, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xf7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0xfb, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x98, 0x1f, 0xf0, 0x7d, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x38, 0x18, 0x60, 0x3e, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x78, 0x10, 0x00, 0x3f, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xf8, 0x00, 0x08, 0x1f, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xf8, 0x00, 0x18, 0x1f, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xf8, 0x18, 0x18, 0x1f, 0xef, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x18, 0x38, 0x1f, 0xf7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xf3, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x38, 0x38, 0x3f, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xfc, 0x38, 0x38, 0x3f, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xfc, 0x38, 0x38, 0x3f, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x38, 0x30, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x7c, 0x38, 0x30, 0x3e, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x3c, 0x38, 0x70, 0x7c, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x9d, 0xff, 0xf0, 0x79, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0x73, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xe7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xcf, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0x9f, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0x3f, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xfe, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfc, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xf9, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xf3, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xe7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xcf, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0x9f, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0x3f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x27, 0xf4, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

Adafruit_SH1106G display = Adafruit_SH1106G(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);  // definicja wyswietlacza 

void setup() {
  Serial.begin(9600);
  delay(250);
  display.begin(i2c_Address, true);  // inicjacja wyswietlacza
  display.display();  // wyswietlenie bufora (wymagane przy uruchomieniu skryptu)
  delay(2000);
  display.clearDisplay();  // wyczyszczenie bufora wyswietlacza 
  display.drawBitmap(0, 0, logo, 128, 64, SH110X_WHITE);  // rysowanie bitmapy
  display.display();
}

void loop() {
  // pusto
}
