#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <FS.h>

const char *ssid = "Nazwa Sieci";
const char *password = "Hasło Sieci";

const int PinDioda = D2;

ESP8266WebServer server(80);

void handleON() 
{
  digitalWrite(PinDioda, HIGH);
  Serial.println("Dioda włączona ");
  server.send(200, "text/plain", "Dioda włączona");
}

void handleOFF() 
{
  digitalWrite(PinDioda, LOW);
  Serial.println("Dioda wyłączona ");
  server.send(200, "text/plain", "Dioda wyłączona");
}

void handleRoot() 
{
  File file = SPIFFS.open("/index.html", "r");
  if (file) 
  {
    Serial.println("ładowanie html");
    server.streamFile(file, "text/html");
    file.close();
  }
}

void setup() 
{
  pinMode(PinDioda, OUTPUT);
  Serial.begin(115200);
  delay(10);

  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(1000);
    Serial.println("Connecting to WiFi...");
  }

  Serial.println("Connected to WiFi");
  Serial.println("Adres IP ESP8266: " + WiFi.localIP().toString());

  server.on("/", HTTP_GET, handleRoot);
  server.on("/on", HTTP_GET, handleON);
  server.on("/off", HTTP_GET, handleOFF);

  SPIFFS.begin();
  server.begin();
}

void loop() 
{
  server.handleClient();
}