#include <SPI.h>
#include <MFRC522.h>
#include <ESP32Servo.h>

// RC522 (SPI)
#define SS_PIN   7
#define RST_PIN  2

// SERVO
const int SERVO_PIN = 10;

MFRC522 rfid(SS_PIN, RST_PIN);
Servo s;

bool isOpen = false;
unsigned long lastTrigger = 0;
const unsigned long cooldownMs = 1500;

// ---- DOPUSZCZONE UID (WHITELIST) ----
// Wpisz tu UID swoich kart w HEX (z Serial Monitora).
// Uwaga: niektóre karty mają 4 bajty UID, inne 7 lub 10.
// Ten przykład pokazuje 4-bajtowe UID.

const byte allowedUids[][10] = {
  {0x0A, 0xD2, 0x74, 0x06},   // karta 1 (przykład)
  {0x12, 0x34, 0x56, 0x78}    // karta 2 (przykład)
};
const byte allowedUidSizes[] = { 4, 4 };
const int allowedCount = sizeof(allowedUidSizes) / sizeof(allowedUidSizes[0]);

bool isAllowedUid(const MFRC522::Uid &uid)
{
  for (int k = 0; k < allowedCount; k++)
  {
    if (uid.size != allowedUidSizes[k]) continue;

    bool match = true;
    for (byte i = 0; i < uid.size; i++)
    {
      if (uid.uidByte[i] != allowedUids[k][i]) { match = false; break; }
    }
    if (match) return true;
  }
  return false;
}

void setup()
{
  Serial.begin(115200);
  delay(200);

  // Serwo
  s.setPeriodHertz(50);
  s.attach(SERVO_PIN, 500, 2400);
  s.write(0);

  // SPI dla ESP32-C3: SCK=4, MISO=5, MOSI=6, SS=7
  SPI.begin(4, 5, 6, SS_PIN);
  rfid.PCD_Init();

  Serial.println("Gotowe. Przyloz karte do RC522...");
}

void loop()
{
  if (!rfid.PICC_IsNewCardPresent()) return;
  if (!rfid.PICC_ReadCardSerial()) return;

  unsigned long now = millis();
  
  if (now - lastTrigger < cooldownMs)
  {
    rfid.PICC_HaltA();
    rfid.PCD_StopCrypto1();
    return;
  }
  lastTrigger = now;

  // Wypisz UID
  Serial.print("UID: ");
  for (byte i = 0; i < rfid.uid.size; i++)
  {
    if (rfid.uid.uidByte[i] < 0x10) Serial.print("0");
    Serial.print(rfid.uid.uidByte[i], HEX);
  }
  Serial.println();

  // Sprawdź uprawnienia
  if (!isAllowedUid(rfid.uid))
  {
    Serial.println("BRAK DOSTEPU");
    rfid.PICC_HaltA();
    rfid.PCD_StopCrypto1();
    return;
  }

  // TOGGLE serwa tylko dla dozwolonej karty
  isOpen = !isOpen;
  s.write(isOpen ? 90 : 0);
  Serial.println(isOpen ? "OTWARTE" : "ZAMKNIETE");

  rfid.PICC_HaltA();
  rfid.PCD_StopCrypto1();
}
