#include <Wire.h>
#include "Adafruit_VL53L0X.h"

Adafruit_VL53L0X lox = Adafruit_VL53L0X();

void setup() 
{
  Serial.begin(115200);
  while (!Serial) { delay(10); }

  Wire.begin();

  Serial.println("Start VL53L0X...");

  if (!lox.begin()) {
    Serial.println("Blad: nie wykryto VL53L0X. Sprawdz polaczenia I2C i zasilanie.");
    while (1) { delay(100); }
  }

  Serial.println("VL53L0X OK.");
}

void loop() 
{
  VL53L0X_RangingMeasurementData_t measure;

  lox.rangingTest(&measure, false); // false = bez debugowania

  if (measure.RangeStatus != 4) 
  { // 4 = out of range
    Serial.print("Odleglosc: ");
    Serial.print(measure.RangeMilliMeter);
    Serial.println(" mm");
  } else {
    Serial.println("Poza zasiegiem / brak poprawnego pomiaru.");
  }

  delay(200);
}
