#include <Wire.h>
#include <INA226_WE.h>

#define INA226_ADDR 0x40

INA226_WE ina226(INA226_ADDR);

void setup() 
{
  Serial.begin(115200);

  // ESP32 domyślnie: SDA=21, SCL=22
  Wire.begin(21, 22);

  if (!ina226.init()) 
  {
    Serial.println("Nie znaleziono INA226 (adres 0x40). Sprawdz polaczenia/I2C!");
    while (1) { delay(10); }
  }

  // Ustawienia pomiaru 
  ina226.setAverage(INA226_AVERAGE_16);
  ina226.setConversionTime(INA226_CONV_TIME_1100);
  ina226.setMeasureMode(INA226_CONTINUOUS);

  // Kalibracja: na module masz R100 = 0.1 ohm
  // Drugi parametr to maksymalny spodziewany prad (dobierz pod siebie)
  ina226.setResistorRange(0.1, 5.0);

  Serial.println("INA226 OK, start pomiarow");
}

void loop() 
{
  float busVoltage_V   = ina226.getBusVoltage_V();
  float shuntVoltage_mV= ina226.getShuntVoltage_mV();
  float current_mA     = ina226.getCurrent_mA();
  float power_mW       = ina226.getBusPower();

  Serial.print("Ubus=");
  Serial.print(busVoltage_V, 4);
  Serial.print(" V | Ushunt=");
  Serial.print(shuntVoltage_mV, 3);
  Serial.print(" mV | I=");
  Serial.print(current_mA, 2);
  Serial.print(" mA | P=");
  Serial.print(power_mW, 2);
  Serial.println(" mW");

  delay(1000);
}
