#ifndef FONT5X7_H
#define FONT5X7_H

#ifdef __AVR__
 #include <avr/io.h>
 #include <avr/pgmspace.h>
#elif defined(ESP8266)
 #include <pgmspace.h>
#else
 #define PROGMEM
#endif

// Standard ASCII 5x7 font

static const unsigned char font[] PROGMEM = {
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x20, 0x00, 0x10, 0x10, // \001 rssi 00__
    0x08, 0x08, 0x00, 0x04, 0x04, // \002 rssi __00
    0x60, 0x60, 0x00, 0x10, 0x10, // \003 rssi 10__
    0x60, 0x60, 0x00, 0x70, 0x70, // \004 rssi 11__
    0x78, 0x78, 0x00, 0x04, 0x04, // \005 rssi __10
    0x78, 0x78, 0x00, 0x7C, 0x7C, // \006 rssi __11
    0x00, 0x1C, 0x1C, 0x1C, 0x00, // \007 weather div
    0x7A, 0x00, 0x7E, 0x12, 0x1E, // \010 ip
    0x06, 0x09, 0x09, 0x06, 0x00, // \011 degree
    0xFF, 0xE7, 0xDB, 0xE7, 0xFF, // 0x0a LINE FEED --- LF10
    0x30, 0x48, 0x3A, 0x06, 0x0E,
    0x26, 0x29, 0x79, 0x29, 0x26,
    0x40, 0x7F, 0x05, 0x05, 0x07, // 0x0d CARRIAGE RETURN ---  CR13
    0x60, 0x7F, 0x05, 0x35, 0x3F, // \016 note
    0x5A, 0x3C, 0xE7, 0x3C, 0x5A,
    0x00, 0x7F, 0x3E, 0x1C, 0x08, // \020 next/play
    0x08, 0x1C, 0x3E, 0x7F, 0x00, // \021 prev
    0x14, 0x22, 0x7F, 0x22, 0x14,
    0x00, 0x00, 0x18, 0x3C, 0x7E, // \023 speaker
    0x18, 0x00, 0x00, 0x00, 0x00, // \024 25%
    0x18, 0x42, 0x3C, 0x00, 0x00, // \025 50%
    0x18, 0x42, 0x3C, 0x42, 0x3C, // \026 100%
    0x94, 0xA2, 0xFF, 0xA2, 0x94,
    0x08, 0x04, 0x7E, 0x04, 0x08,
    0x10, 0x20, 0x7E, 0x20, 0x10,
    0x08, 0x08, 0x2A, 0x1C, 0x08,
    0x08, 0x1C, 0x2A, 0x08, 0x08,
    0x7F, 0x7F, 0x00, 0x7F, 0x7F, // \034 pause
    0x55, 0x00, 0x55, 0x55, 0x55, // \035 list
    0x30, 0x38, 0x3E, 0x38, 0x30,    // 0x1e RECORD SEPARATOR
    0x06, 0x0E, 0x3E, 0x0E, 0x06,    // 0x1f  UNIT SEPARATOR
    0x00, 0x00, 0x00, 0x00, 0x00, // 0x20 SPACE
    0x00, 0x00, 0x5F, 0x00, 0x00, // 0x21 !
    0x00, 0x07, 0x00, 0x07, 0x00, // 0x22 "
    0x14, 0x7F, 0x14, 0x7F, 0x14, // 0x23 #
    0x24, 0x2A, 0x7F, 0x2A, 0x12,       // 0x24 $
    0x23, 0x13, 0x08, 0x64, 0x62, // 0x25 %
    0x36, 0x49, 0x56, 0x20, 0x50, // 0x26 &
    0x00, 0x08, 0x07, 0x03, 0x00, // 0x27 '
    0x00, 0x1C, 0x22, 0x41, 0x00, // 0x28 (
    0x00, 0x41, 0x22, 0x1C, 0x00, // 0x29 )
    0x2A, 0x1C, 0x7F, 0x1C, 0x2A, // 0x2a *
    0x08, 0x08, 0x3E, 0x08, 0x08, // 0x2b +
    0x00, 0x80, 0x70, 0x30, 0x00, // 0x2c ,
    0x08, 0x08, 0x08, 0x08, 0x08, // 0x2d -
    0x00, 0x00, 0x60, 0x60, 0x00, // 0x2e .
    0x20, 0x10, 0x08, 0x04, 0x02, // 0x2f /
    0x3E, 0x51, 0x49, 0x45, 0x3E, // 0x30 0
    0x00, 0x42, 0x7F, 0x40, 0x00, // 0x31 1
    0x72, 0x49, 0x49, 0x49, 0x46, // 0x32 2
    0x21, 0x41, 0x49, 0x4D, 0x33, // 0x33 3
    0x18, 0x14, 0x12, 0x7F, 0x10, // 0x34 4
    0x27, 0x45, 0x45, 0x45, 0x39, // 0x35 5
    0x3C, 0x4A, 0x49, 0x49, 0x31, // 0x36 6
    0x41, 0x21, 0x11, 0x09, 0x07, // 0x37 7
    0x36, 0x49, 0x49, 0x49, 0x36, // 0x38 8
    0x46, 0x49, 0x49, 0x29, 0x1E, // 0x39 9
    0x00, 0x00, 0x14, 0x00, 0x00, // 0x3a :
    0x00, 0x40, 0x34, 0x00, 0x00, // 0x3b ;
    0x00, 0x08, 0x14, 0x22, 0x41, // 0x3C <
    0x14, 0x14, 0x14, 0x14, 0x14, // 0x3D =
    0x00, 0x41, 0x22, 0x14, 0x08, // 0x3E >
    0x02, 0x01, 0x59, 0x09, 0x06, // 0x3f ?
    0x3E, 0x41, 0x5D, 0x59, 0x4E, // 0x40 @
    0x7C, 0x12, 0x11, 0x12, 0x7C, // 0x41 A
    0x7F, 0x49, 0x49, 0x49, 0x36, // 0x42 B
    0x3E, 0x41, 0x41, 0x41, 0x22, // 0x43 C
    0x7F, 0x41, 0x41, 0x41, 0x3E, // 0x44 D
    0x7F, 0x49, 0x49, 0x49, 0x41, // 0x45 E
    0x7F, 0x09, 0x09, 0x09, 0x01, // 0x46 F
    0x3E, 0x41, 0x41, 0x51, 0x73, // 0x47 G
    0x7F, 0x08, 0x08, 0x08, 0x7F, // 0x48 H
    0x00, 0x41, 0x7F, 0x41, 0x00, // 0x49 I
    0x20, 0x40, 0x41, 0x3F, 0x01, // 0x4a J
    0x7F, 0x08, 0x14, 0x22, 0x41, // 0x4b K
    0x7F, 0x40, 0x40, 0x40, 0x40, // 0x4c L
    0x7F, 0x02, 0x1C, 0x02, 0x7F, // 0x4d M
    0x7F, 0x04, 0x08, 0x10, 0x7F, // 0x4e N
    0x3E, 0x41, 0x41, 0x41, 0x3E, // 0x4f O
    0x7F, 0x09, 0x09, 0x09, 0x06, // 0x50 P
    0x3E, 0x41, 0x51, 0x21, 0x5E, // 0x51 Q
    0x7F, 0x09, 0x19, 0x29, 0x46, // 0x52 R
    0x26, 0x49, 0x49, 0x49, 0x32, // 0x53 S
    0x03, 0x01, 0x7F, 0x01, 0x03, // 0x54 T
    0x3F, 0x40, 0x40, 0x40, 0x3F, // 0x55 U
    0x1F, 0x20, 0x40, 0x20, 0x1F, // 0x56 V
    0x3F, 0x40, 0x38, 0x40, 0x3F, // 0x57 W
    0x63, 0x14, 0x08, 0x14, 0x63, // 0x58 X
    0x03, 0x04, 0x78, 0x04, 0x03, // 0x59 Y
    0x61, 0x59, 0x49, 0x4D, 0x43, // 0x5a Z
    0x00, 0x7F, 0x41, 0x41, 0x41, // 0x5b [
    0x02, 0x04, 0x08, 0x10, 0x20, // 0x5c BACKSLASH
    0x00, 0x41, 0x41, 0x41, 0x7F, // 0x5b [
    0x04, 0x02, 0x01, 0x02, 0x04, // 0x5e ^
    0x40, 0x40, 0x40, 0x40, 0x40, // 0x5f _
    0x00, 0x03, 0x07, 0x08, 0x00, // 0x60 `
    0x20, 0x54, 0x54, 0x78, 0x40, // 0x61 a
	  0x7F, 0x28, 0x44, 0x44, 0x38, // 0x62 b
	  0x38, 0x44, 0x44, 0x44, 0x28, // 0x63 c
	  0x38, 0x44, 0x44, 0x28, 0x7F, // 0x64 d
	  0x38, 0x54, 0x54, 0x54, 0x18, // 0x65 e
	  0x00, 0x08, 0x7E, 0x09, 0x02, // 0x66 f
	  0x18, 0xA4, 0xA4, 0x9C, 0x78, // 0x67 g
	  0x7F, 0x08, 0x04, 0x04, 0x78, // 0x68 h
	  0x00, 0x44, 0x7D, 0x40, 0x00, // 0x69 i
	  0x20, 0x40, 0x40, 0x3D, 0x00, // 0x6a j
	  0x7F, 0x10, 0x28, 0x44, 0x00, // 0x6b k
	  0x00, 0x41, 0x7F, 0x40, 0x00, // 0x6c l
	  0x7C, 0x04, 0x78, 0x04, 0x78, // 0x6d m
	  0x7C, 0x08, 0x04, 0x04, 0x78, // 0x6e n
	  0x38, 0x44, 0x44, 0x44, 0x38, // 0x6f o
	  0xFC, 0x18, 0x24, 0x24, 0x18, // 0x70 p
	  0x18, 0x24, 0x24, 0x18, 0xFC, // 0x71 q
	  0x7C, 0x08, 0x04, 0x04, 0x08, // 0x72 r
	  0x48, 0x54, 0x54, 0x54, 0x24, // 0x73 s
	  0x04, 0x04, 0x3F, 0x44, 0x24, // 0x74 t
	  0x3C, 0x40, 0x40, 0x20, 0x7C, // 0x75 u
	  0x1C, 0x20, 0x40, 0x20, 0x1C, // 0x76 v
	  0x3C, 0x40, 0x30, 0x40, 0x3C, // 0x77 w
	  0x44, 0x28, 0x10, 0x28, 0x44, // 0x78 x
	  0x4C, 0x90, 0x90, 0x90, 0x7C, // 0x79 y
    0x44, 0x64, 0x54, 0x4C, 0x44, // 0x7a z
    0x00, 0x08, 0x36, 0x41, 0x00, // 0x7b {
    0x00, 0x00, 0x77, 0x00, 0x00, // 0x7c |
    0x00, 0x41, 0x36, 0x08, 0x00, // 0x7d }
    0x02, 0x01, 0x02, 0x04, 0x02, // 0x7e ~
    0x3C, 0x26, 0x23, 0x26, 0x3C, // ⌂  \0x7f
	  0x1E, 0xA1, 0xA1, 0x61, 0x12, // Ç  \0x80
	  0x3A, 0x40, 0x40, 0x20, 0x7A, // u-umlaut  ü  \0x81
	  0x38, 0x54, 0x56, 0x55, 0x08, //   é slovakia //0x38, 0x54, 0x54, 0x55, 0x59, // é  \0x82
    0x21, 0x55, 0x55, 0x79, 0x41, // â  \0x83
    0x22, 0x54, 0x54, 0x78, 0x42, // a-umlaut \  ä  \0x84
    0x21, 0x55, 0x54, 0x78, 0x40, // à  \0x85
    0x20, 0x54, 0x55, 0x79, 0x40, // å  \0x86
    0x0C, 0x1E, 0x52, 0x72, 0x12, // ç  \0x87
    0x39, 0x55, 0x55, 0x55, 0x59, // ê  \0x88
    0x39, 0x54, 0x54, 0x54, 0x59, // ë  \0x89
    0x39, 0x55, 0x54, 0x54, 0x58, // è  \0x8a
    0x00, 0x00, 0x45, 0x7C, 0x41, // ï  \0x8b
    0x00, 0x02, 0x45, 0x7D, 0x42, // î  \0x8c
    0x00, 0x01, 0x45, 0x7C, 0x40, // ì  \0x8d
    0x7D, 0x12, 0x11, 0x12, 0x7D, // A-umlaut \ Ä  \0x8e
    0xF0, 0x28, 0x25, 0x28, 0xF0, // Å  \0x8f
    0x7C, 0x54, 0x56, 0x55, 0x44, //   É slovakia //0x7C, 0x54, 0x55, 0x45, 0x00, // É  \0x90
    0x20, 0x54, 0x54, 0x7C, 0x54, // æ  \0x91
    0x7C, 0x0A, 0x09, 0x7F, 0x49, // Æ  \0x92
    0x32, 0x49, 0x49, 0x49, 0x32, // ô  \0x93
    0x3A, 0x44, 0x44, 0x44, 0x3A, // o-umlaut \ ö  \0x94
    0x32, 0x4A, 0x48, 0x48, 0x30, // ò  \0x95
    0x3A, 0x41, 0x41, 0x21, 0x7A, // û  \0x96
    0x3A, 0x42, 0x40, 0x20, 0x78, // ù  \0x97
    0x00, 0x9D, 0xA0, 0xA0, 0x7D, // ÿ  \0x98
    0x3D, 0x42, 0x42, 0x42, 0x3D, // O-umlaut  \ Ö  \0x99
    0x3D, 0x40, 0x40, 0x40, 0x3D, // U-umlauf  \ Ü  \0x9a
    0x3C, 0x24, 0xFF, 0x24, 0x24, // ¢  \0x9b
    0x48, 0x7E, 0x49, 0x43, 0x66, // £  \0x9c
    0x3C, 0x40, 0x42, 0x40, 0x3C, //   Ů slovakia ////0x2B, 0x2F, 0xFC, 0x2F, 0x2B, // ¥  \0x9d
    0xFF, 0x09, 0x29, 0xF6, 0x20, // ₧  \0x9e
    0xC0, 0x88, 0x7E, 0x09, 0x03, // ƒ  \0x9f
    0x20, 0x54, 0x54, 0x79, 0x41, // á  \0xa0
    0x00, 0x00, 0x44, 0x7D, 0x41, // í  \0xa1
    0x30, 0x48, 0x48, 0x4A, 0x32, // ó  \0xa2
    0x38, 0x40, 0x40, 0x22, 0x7A, // ú  \0xa3
    0x00, 0x7A, 0x0A, 0x0A, 0x72, // ñ  \0xa4
    0x7D, 0x0D, 0x19, 0x31, 0x7D, // Ñ  \0xa5
    0x26, 0x29, 0x29, 0x2F, 0x28, // ª  \0xa6
    0x26, 0x29, 0x29, 0x29, 0x26, // º  \0xa7
    0x30, 0x48, 0x4D, 0x40, 0x20, // ¿  \0xa8
    0x38, 0x08, 0x08, 0x08, 0x08, // ⌐  \0xa9
    0x08, 0x08, 0x08, 0x08, 0x38, // ¬  \0xaa
    0x2F, 0x10, 0xC8, 0xAC, 0xBA, // ½  \0xab
    0x2F, 0x10, 0x28, 0x34, 0xFA, // ¼  \0xac
    0x00, 0x00, 0x7B, 0x00, 0x00, // ¡  \0xad
    0x08, 0x14, 0x2A, 0x14, 0x22, // «  \0xae
    0x22, 0x14, 0x2A, 0x14, 0x08, // »  \0xaf
    0x55, 0x00, 0x55, 0x00, 0x55, // 25% block
    0xAA, 0x55, 0xAA, 0x55, 0xAA, // 50% block  \0xb0
    0xFF, 0x55, 0xFF, 0x55, 0xFF, // 75% block 
    0x7C, 0x09, 0x12, 0x21, 0x7C, //   Ň slovakia //0x00, 0x00, 0x00, 0xFF, 0x00, // │  \0xb3
    0x78, 0x11, 0x0A, 0x09, 0x70, //   ň slovakia //0x10, 0x10, 0x10, 0xFF, 0x00, // ┤  \0xb4
    0x7C, 0x14, 0x16, 0x15, 0x68, //   Ŕ slovakia //0x14, 0x14, 0x14, 0xFF, 0x00, // ╡  \0xb5
    0x78, 0x11, 0x0A, 0x09, 0x10, //   ř slovakia //0x10, 0x10, 0xFF, 0x00, 0xFF, // ╢  \0xb6
    0b01111100, 0b00010010, 0b00010001, 0b10010010, 0b01111100,//Ą    \0xb7
    0b00100000, 0b01010100, 0b01010100, 0b11111000, 0b01000000,//ą    \0xb8
    0b01000100, 0b01100100, 0b01010101, 0b01001100, 0b01000100,//ż    \0xb9
    0b01100001, 0b01011011, 0b01001001, 0b01001101, 0b01000011,//Ż    \0xba
    0b01000100, 0b01100100, 0b01010110, 0b01001101, 0b01000100,//ź    \0xbb
    0b01100101, 0b01011001, 0b01001001, 0b01001101, 0b01010011,//Ź    \0xbc
    0x30, 0x48, 0x4A, 0x49, 0x48, // ć -PL  \0xbd 
    0b00111000, 0b01000100, 0b01000110, 0b01000101, 0b00111000,//ó	   \0xbe
    0b00111110, 0b01000001, 0b01000011, 0b01000001, 0b00111110,//Ó	   \0xbf
    0b01111100, 0b00001000, 0b00000110, 0b00000101, 0b01111000,//ń     \0xc0
    0b01111111, 0b00000100, 0b00001011, 0b00010000, 0b01111111,//Ń	   \0xc1
    0x48, 0x55, 0x56, 0x55, 0x34, //   Š slovakia //0x10, 0x10, 0x10, 0xF0, 0x10, // ┬  \0xc2
    0x00, 0x51, 0x7A, 0x29, 0x00, //   š slovakia //0x00, 0x00, 0x00, 0xFF, 0x10, // ├  \0xc3
    0x3E, 0x41, 0x43, 0x41, 0x22,  //Ć -PL \0xc4 
    0x04, 0x05, 0x7E, 0x05, 0x04, //   Ť slovakia //0x10, 0x10, 0x10, 0xFF, 0x10, // ┼  \0xc5
    0x00, 0x08, 0x3C, 0x49, 0x22, //   ť slovakia //0x00, 0x00, 0x00, 0xFF, 0x14, // ╞  \0xc6
    0x64, 0x55, 0x56, 0x55, 0x4C, //   Ž slovakia //0x00, 0x00, 0xFF, 0x00, 0xFF, // ╟  \0xc7
    0x00, 0x69, 0x7A, 0x59, 0x00, //   ž slovakia //0x00, 0x00, 0x1F, 0x10, 0x17, // ╚  \0xc8
    0x38, 0x45, 0x46, 0x45, 0x44, //   Č slovakia //0x00, 0x00, 0xFC, 0x04, 0xF4, // ╔  \0xc9
    0x30, 0x49, 0x4A, 0x49, 0x48, //   č slovakia //0x14, 0x14, 0x17, 0x10, 0x17, // ╩  \0xca
    0b01001000, 0b01010100, 0b01010110, 0b01010101, 0b00100100,//ś    \0xcb
    0b00100110, 0b01001001, 0b01001011, 0b01001001, 0b00110010,//Ś    \0xcc
    0x14, 0x14, 0x14, 0x14, 0x14, //horiz lines  ═  \0xcd
    0x7C, 0x45, 0x46, 0x45, 0x38, //   Ď slovakia //0x14, 0x14, 0xF7, 0x00, 0xF7, // ╬  \0xce
    0b00000000, 0b01010001, 0b01111111, 0b01000100, 0b00000000,//ł    \0xcf
    0b01111111, 0b01001000, 0b01000100, 0b01000000, 0b01000000,//Ł    \0xd0
    0x20, 0x70, 0x50, 0x7D, 0x02, //   ď slovakia //0x14, 0x14, 0x14, 0xF4, 0x14, // ╤  \0xd1
    0x7C, 0x40, 0x42, 0x41, 0x40, //   Ĺ slovakia //0x10, 0x10, 0xF0, 0x10, 0xF0, // ╥  \0xd2
    0x02, 0x45, 0x7C, 0x40, 0x00, //   ĺ slovakia //0x00, 0x00, 0x1F, 0x10, 0x1F, // ╙  \0xd3
    0x7C, 0x41, 0x42, 0x40, 0x40, //   Ľ slovakia //0x00, 0x00, 0x00, 0x1F, 0x14, // ╘  \0xd4
    0x00, 0x44, 0x7C, 0x41, 0x02, //   ľ slovakia //0x00, 0x00, 0x00, 0xFC, 0x14, // ╒  \0xd5
    0b00111000, 0b01010100, 0b01010100, 0b11010100, 0b00011000,//ę    \0xd6
    0b01111111, 0b01001001, 0b01001001, 0b11001001, 0b01000001,//Ę    \0xd7
    0x78, 0x14, 0x16, 0x15, 0x78, //   Á slovakia //0x14, 0x14, 0x14, 0xFF, 0x14, // ╪  \0xd8
    0x20, 0x54, 0x56, 0x79, 0x40, //   á slovakia //0x10, 0x10, 0x10, 0x1F, 0x00, // ┘  \0xd9
    0x00, 0x44, 0x7E, 0x45, 0x00, //   Í slovakia //0x00, 0x00, 0x00, 0xF0, 0x10, // ┌  \0xda
    0x00, 0x40, 0x7A, 0x41, 0x00, //   í slovakia //0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // █  \0xdb
    0x38, 0x46, 0x45, 0x46, 0x38, //   Ô slovakia //0xF0, 0xF0, 0xF0, 0xF0, 0xF0, // ▄  \0xdc
    0x30, 0x4A, 0x49, 0x4A, 0x30, //   ô slovakia //0xFF, 0xFF, 0xFF, 0x00, 0x00, // ▌  \0xdd
    0x3C, 0x40, 0x42, 0x41, 0x3C, //   Ú slovakia //0x00, 0x00, 0x00, 0xFF, 0xFF, // ▐  \0xde
    0x38, 0x40, 0x42, 0x21, 0x78, //   ú slovakia //0x0F, 0x0F, 0x0F, 0x0F, 0x0F, // ▀  \0xdf
    0x38, 0x44, 0x44, 0x38, 0x44, // α  \0xe0
    0xFC, 0x4A, 0x4A, 0x4A, 0x34, // sharp-s or beta \0xe1
    0x04, 0x08, 0x72, 0x09, 0x04, //   Ý slovakia //0x7E, 0x02, 0x02, 0x06, 0x06, // Γ  \0xe2
    0x18, 0xA0, 0xA2, 0xA1, 0x78, //   ý slovakia //0x02, 0x7E, 0x02, 0x7E, 0x02, // π  \0xe3
    0x63, 0x55, 0x49, 0x41, 0x63, // Σ  \0xe4
    0x38, 0x44, 0x44, 0x3C, 0x04, // σ  \0xe5
    0x40, 0x7E, 0x20, 0x1E, 0x20, // µ  \0xe6
    0x06, 0x02, 0x7E, 0x02, 0x02, // τ  \0xe7
    0x38, 0x40, 0x42, 0x20, 0x78, //   ů slovakia //00x99, 0xA5, 0xE7, 0xA5, 0x99, // Φ  \0xe8
    0x1C, 0x2A, 0x49, 0x2A, 0x1C, // Θ  \0xe9
    0x4C, 0x72, 0x01, 0x72, 0x4C, // Ω  \0xea
    0x30, 0x4A, 0x4D, 0x4D, 0x30, // δ  \0xeb
    0x30, 0x48, 0x78, 0x48, 0x30, // ∞  \0xec
    0xBC, 0x62, 0x5A, 0x46, 0x3D, // φ  \0xed
    0x3E, 0x49, 0x49, 0x49, 0x00, // ε  \0xee
    0x7E, 0x01, 0x01, 0x01, 0x7E, // ∩  \0xef
    0x2A, 0x2A, 0x2A, 0x2A, 0x2A, // ≡  \0xf0
    0x44, 0x44, 0x5F, 0x44, 0x44, // ±  \0xf1
    0x40, 0x51, 0x4A, 0x44, 0x40, // ≥  \0xf2
    0x40, 0x44, 0x4A, 0x51, 0x40, // ≤  \0xf3
    0x00, 0x00, 0xFF, 0x01, 0x03, // ⌠  \0xf4
    0xE0, 0x80, 0xFF, 0x00, 0x00, // ⌡  \0xf5
    0x08, 0x08, 0x6B, 0x6B, 0x08, // ÷  \0xf6
    0x36, 0x12, 0x36, 0x24, 0x36, // ≈  \0xf7
    0x06, 0x0F, 0x09, 0x0F, 0x06, // °  \0xf8
    0x00, 0x00, 0x18, 0x18, 0x00, // ∙  \0xf9
    0x00, 0x00, 0x10, 0x10, 0x00, // ·  \0xfa
    0x30, 0x40, 0xFF, 0x01, 0x01, // √  \0xfb
    0x00, 0x1F, 0x01, 0x01, 0x1E, // ⁿ  \0xfc
    0x00, 0x19, 0x1D, 0x17, 0x12, // ²  \0xfd
    0x00, 0x3C, 0x3C, 0x3C, 0x3C, // ■  \0xfe
    0x00, 0x00, 0x00, 0x00, 0x00 // #255 NBSP \0xff
};

static inline void avoid_unused_const_variable_compiler_warning(void) {
  (void)font;
}
#endif // FONT5X7_H
