#include <Adafruit_NeoPixel.h>

#define PIN 1
#define NUMPIXELS 64
#define MIC_PIN 0

Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

int minSoundLevel = 1550;  // Dolny próg, zależny od środowiska
int maxSoundLevel = 2000;  // Górny próg, maksymalna wartość, przy której chcesz reakcję

int smoothSound = 0; // Zmienna do wygładzania
int brightness = 50; // Zmienna do regulacji jasności 0-255

// Funkcja do interpolacji kolorów z uwzględnieniem jasności
uint32_t interpolateColor(uint32_t color1, uint32_t color2, float ratio) 
{
  uint8_t r1 = (color1 >> 16) & 0xFF;
  uint8_t g1 = (color1 >> 8) & 0xFF;
  uint8_t b1 = color1 & 0xFF;
  uint8_t r2 = (color2 >> 16) & 0xFF;
  uint8_t g2 = (color2 >> 8) & 0xFF;
  uint8_t b2 = color2 & 0xFF;
  
  uint8_t r = r1 + ratio * (r2 - r1);
  uint8_t g = g1 + ratio * (g2 - g1);
  uint8_t b = b1 + ratio * (b2 - b1);
  
  // Zastosowanie jasności
  r = (r * brightness) / 255;
  g = (g * brightness) / 255;
  b = (b * brightness) / 255;
  
  return strip.Color(r, g, b);
}

void setup() {
  strip.begin();
  strip.show();
  pinMode(MIC_PIN, INPUT);
  Serial.begin(115200);
}

void loop() 
{
  int soundLevel = analogRead(MIC_PIN);  // Odczyt poziomu dźwięku

  // Wygładzanie sygnału
  smoothSound = (smoothSound * 0.8) + (soundLevel * 0.2); 
  
  // Mapowanie wartości sygnału na zakres liczby zapalonych wierszy
  int numRows = map(smoothSound, minSoundLevel, maxSoundLevel, 1, 8);  
  numRows = constrain(numRows, 1, 8);  // Ograniczenie zakresu do 0-8
  
  // Kolory do interpolacji
  uint32_t colorStart = strip.Color(0, 255, 0);     // Zielony
  uint32_t colorEnd = strip.Color(255, 0, 0);       // Czerwony

  for (int row = 0; row < 8; row++) 
  {
    uint32_t color;
    float ratio = (float)row / 7.0;  // Normalizowany wskaźnik od 0 do 1

    // Interpolacja kolorów od zielonego do czerwonego
    color = interpolateColor(colorStart, colorEnd, ratio);

    // Ustawienie koloru w całym wierszu, jeśli wiersz jest w zakresie liczby zapalonych wierszy
    for (int col = 0; col < 8; col++) 
    {
      if (row < numRows) {
        strip.setPixelColor(row * 8 + col, color); // Ustaw kolor dla odpowiedniego piksela
      } else {
        strip.setPixelColor(row * 8 + col, strip.Color(0, 0, 0)); // Wyłączone diody
      }
    }
  }

  strip.show();
  delay(50);
}