#include "DFRobotDFPlayerMini.h"
#include <Adafruit_NeoPixel.h>

#define PIR_PIN 7        // pin czujnika PIR MH-SR602
#define LED_PIN 8        // pin danych dla WS2812B
#define LED_COUNT 16     // liczba diod


#define mySerial Serial1
DFRobotDFPlayerMini myDFPlayer;
Adafruit_NeoPixel ring(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);

// Zmienna stanu ruchu, by unikać wielokrotnego odtwarzania
bool motionActive = false;

void setup() 
{
  delay(1000);
  Serial.begin(115200);
  mySerial.begin(9600, SERIAL_8N1, /*rx =*/9, /*tx =*/10);

  Serial.println();
  Serial.println(F("Inicjalizacja DFPlayer Mini..."));
  
  if (!myDFPlayer.begin(mySerial, /*isACK=*/true, /*doReset=*/true)) 
  {
    Serial.println(F("Błąd DFPlayera! Sprawdź połączenia i kartę SD."));
    while(true) delay(0);
  }

  Serial.println(F("DFPlayer Mini online."));
  myDFPlayer.volume(30); // głośność 0–30

  // WS2812B
  ring.begin();
  ring.setBrightness(255); // Jasność (0-255)
  ring.show(); // zgaś diody

  // PIR
  pinMode(PIR_PIN, INPUT);
  Serial.println(F("Czujnik PIR gotowy."));
}

void loop()
{
  int motionDetected = digitalRead(PIR_PIN);

  if (motionDetected == HIGH && !motionActive) 
  {
    motionActive = true;
    Serial.println(F("Ruch wykryty!"));

    // zapal diody na czerwono
    for (int i = 0; i < LED_COUNT; i++) 
    {
      ring.setPixelColor(i, ring.Color(255, 0, 0));
    }
    ring.show();

    // zagraj dźwięk (plik 001.mp3)
    myDFPlayer.play(1);
  } 
  else if (motionDetected == LOW && motionActive) 
  {
    // brak ruchu -> zgaś diody
    motionActive = false;
    for (int i = 0; i < LED_COUNT; i++) 
    {
      ring.setPixelColor(i, ring.Color(0, 0, 0));
    }
    ring.show();
    Serial.println(F("Brak ruchu."));
  }

  delay(100); // opóźnienie dla stabilizacji odczytu PIR
}
