const int lightPin = 34; // pin OUT z czujnika ALS-PT19

void setup() 
{
  Serial.begin(115200);
  delay(500);
  Serial.println("Start pomiaru światła (ALS-PT19)");
}

void loop() 
{
  int raw = analogRead(lightPin);           // odczyt ADC 0–4095
  float voltage = raw * (3.3 / 4095.0);     // napięcie w [V]
  int lightPercent = map(raw, 0, 4095, 0, 100); // orientacyjny % jasności

  Serial.print("ADC: ");
  Serial.print(raw);
  Serial.print("  |  ");
  Serial.print(voltage, 2);
  Serial.print(" V  |  Jasność: ");
  Serial.print(lightPercent);
  Serial.println(" %");

  delay(500);
}