#include <LCDWIKI_GUI.h> //Core graphics library
#include <LCDWIKI_KBV.h> //Hardware-specific library

#define SCREEN_WIDTH 320
#define SCREEN_HEIGHT 480

#define RED     0xF800
#define MAGENTA 0xF81F
#define BLACK   0x0000

LCDWIKI_KBV tft(ILI9486,40,38,39,-1,41); //model,cs,cd,wr,rd,reset

void DrawDimensioning()
{
  tft.Fill_Screen(BLACK);
  delay(1000);
  int x1 = tft.Get_Display_Width() / 3; // współrzędna X dla pionowej linii (1/3 szerokości ekranu)
  int y1 = 1;                             // współrzędna Y dla pionowej linii (górna krawędź)
  int y2 = tft.Get_Display_Height() - 2; // współrzędna Y dla pionowej linii (dolna krawędź)
  int x3 = 1;                              // współrzędna X dla poziomej linii (lewa krawędź)
  int x4 = tft.Get_Display_Width() - 1;     // współrzędna X dla poziomej linii (prawa krawędź)
  int y3 = 16 + 2 * (tft.Get_Display_Height() - 32) / 3;  // współrzędna Y dla poziomej linii (2/3 wysokości ekranu)

  // Ustawienie koloru na czerwony
  tft.Set_Draw_color(RED); 

  // Rysowanie pionowej linii o większej grubości
  int lineThickness = 3; // Grubość linii

  for (int i = 0; i < lineThickness; i++) 
  {
    tft.Draw_Line(x1 + i, y1, x1 + i, y2);
  }

  // Rysowanie poziomej linii o większej grubości
  for (int i = 0; i < lineThickness; i++) 
  {
    tft.Draw_Line(x3, y3 + i, x4, y3 + i);
  }

   // Strzałka na początku pionowej linii
  for (int i = 0; i < 3; i++) 
  {
    tft.Draw_Line(x1 - 6 + i, y1 + 6, x1 - 1 + i, y1 + 1); // Górna część strzałki
    tft.Draw_Line(x1 + 8 - i, y1 + 6, x1 - i + 3, y1 + 1); // Dolna część strzałki
  }
  // Strzałka na końcu pionowej linii
  for (int i = 0; i < 3; i++) 
  {
    tft.Draw_Line(x1 - 6 + i, y2 - 6, x1 - 1 + i, y2 - 1); // Górna część strzałki
    tft.Draw_Line(x1 + 8 - i, y2 - 6, x1 - i + 3, y2 - 1); // Dolna część strzałki
  }

  // Strzałka na początku poziomej linii 
  for (int i = 0; i < 3; i++) {
      tft.Draw_Line(x3 + 6, y3 - 6 + i, x3 + 1, y3 - 1 + i); // Górna część strzałki
      tft.Draw_Line(x3 + 6, y3 + 8 - i, x3 + 1, y3 - i + 3); // Dolna część strzałki
  }
  // Strzałka na końcu poziomej linii
  for (int i = 0; i < 3; i++) {
      tft.Draw_Line(x4 - 6, y3 - 6 + i, x4 - 1, y3 - 1 + i); // Górna część strzałki
      tft.Draw_Line(x4 - 6, y3 + 8 - i, x4 - 1, y3 - i + 3); // Dolna część strzałki
  }

  // Dodanie napisów
  tft.Set_Text_Size(2); // Ustawienie wielkości czcionki
  tft.Set_Text_colour(MAGENTA); // Ustawienie koloru czcionki
  tft.Set_Text_Back_colour(BLACK);

  // Napis "480x" na górnej strzałce po prawej stronie
  tft.Print_String("480px", x1 + 10, y1 + 5);

  // Napis "320" nad końcem prawej strzałki poziomej
  tft.Print_String("320px", x4 - 65, y3 - 20);
}

void setup() 
{
  tft.Init_LCD();
}

void loop()
{
  DrawDimensioning();
  delay(15000);
} 