#include <SPI.h>
#include <Adafruit_Sensor.h>
#include "Adafruit_BMP5xx.h"

Adafruit_BMP5xx bmp;

// Piny VSPI w ESP32
#define BMP5XX_CS   5
#define BMP5XX_SCK  18
#define BMP5XX_MOSI 23
#define BMP5XX_MISO 19

void setup() 
{
  Serial.begin(115200);
  delay(200);

  // start SPI na zadanych pinach
  SPI.begin(BMP5XX_SCK, BMP5XX_MISO, BMP5XX_MOSI, BMP5XX_CS);
  
  if (!bmp.begin(BMP5XX_CS, &SPI)) 
  {
    Serial.println("Nie wykryto BMP580/BMP58x po SPI – sprawdź okablowanie/CS!");
    while (1) 
    { 
      delay(10); 
    }
  }
  Serial.println("BMP58x (SPI) wykryty!");
}

void loop() 
{
  if (!bmp.performReading()) 
  {
    Serial.println("Błąd odczytu!");
    delay(500);
    return;
  }

  Serial.print("Temperatura: ");
  Serial.print(bmp.temperature);
  Serial.println(" °C");

  Serial.print("Ciśnienie: ");
  Serial.print(bmp.pressure);
  Serial.println(" hPa");

  delay(1000);
}
