#include <Wire.h>
#include <Adafruit_Sensor.h>
#include "Adafruit_BMP5xx.h"

Adafruit_BMP5xx bmp;

// wybierz adres I²C – 0x46 SDO=GND lub 0x47 SDO=VDDIO/3V3
#define BMP5XX_I2C_ADDR 0x47

void setup() 
{
  Serial.begin(115200);
  delay(200);

  // opcjonalnie jawnie ustaw piny I²C ESP32
  // Wire.begin(/*SDA=*/21, /*SCL=*/22);

  if (!bmp.begin(BMP5XX_I2C_ADDR, &Wire)) 
  {
    Serial.println("Nie wykryto BMP580/BMP58x sprawdź okablowanie/adres!");
    while (1) { delay(10); }
  }
  Serial.println("BMP58x wykryty!");
}

void loop() 
{
  if (!bmp.performReading()) 
  {
    Serial.println("Błąd odczytu!");
    delay(500);
    return;
  }

  Serial.print("Temperatura: ");
  Serial.print(bmp.temperature);
  Serial.println(" °C");

  Serial.print("Ciśnienie: ");
  Serial.print(bmp.pressure);
  Serial.println(" hPa");

  delay(1000);
}
