#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_INA219.h>

Adafruit_INA219 ina219;

#define SCREEN_WIDTH 128 
#define SCREEN_HEIGHT 64 

#define OLED_RESET     -1 
#define SCREEN_ADDRESS 0x3C 
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void setup() 
{
  Serial.begin(115200);
  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) 
  {
    Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }
  display.display();
  delay(2000); 
  display.clearDisplay();

  if (!ina219.begin()) 
  {
    Serial.println("Failed to find INA219 chip");
    while (1) 
    { 
      delay(10); 
    }
  }

}

void loop() 
{
  float shuntvoltage = 0;
  float busvoltage = 0;
  float current_mA = 0;
  float loadvoltage = 0;
  float power_mW = 0;

  shuntvoltage = ina219.getShuntVoltage_mV();
  busvoltage = ina219.getBusVoltage_V();
  current_mA = ina219.getCurrent_mA();
  power_mW = ina219.getPower_mW();
  loadvoltage = busvoltage + (shuntvoltage / 1000);

  display.clearDisplay();

  display.setTextSize(1);
  display.setTextColor(WHITE);

  display.setCursor(0, 0);
  display.print("Bus Voltage:  ");
  display.print(busvoltage);
  display.println("V");

  display.setCursor(0, 10);
  display.print("Shunt Voltage:");
  display.print(shuntvoltage);
  display.println("mV");

  display.setCursor(0, 20);
  display.print("Current:      ");
  display.print(current_mA);
  display.println("mA");

  display.setCursor(0, 30);
  display.print("Load Voltage: ");
  display.print(loadvoltage);
  display.println("V");

  display.setCursor(0, 40);
  display.print("Power:        ");
  display.print(power_mW);
  display.println("mW");

  display.display(); 
  delay(2000);
}

