	#include <Wire.h>
#include <U8g2lib.h>

U8G2_ST7567_JLX12864_F_HW_I2C u8g2(U8G2_R2, U8X8_PIN_NONE);

#define SCREEN_HEIGHT 64
#define SCREEN_WIDTH 128

// 'logo', 128x64px
const unsigned char logo [] PROGMEM = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2f, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0xbf, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0xdf, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xef, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xf7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xfb, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xfd, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfe, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xff, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xbf, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0xdf, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xef, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xf7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0xfb, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x98, 0x1f, 0xf0, 0x7d, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x38, 0x18, 0x60, 0x3e, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x78, 0x10, 0x00, 0x3f, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xf8, 0x00, 0x08, 0x1f, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xf8, 0x00, 0x18, 0x1f, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xf8, 0x18, 0x18, 0x1f, 0xef, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x18, 0x38, 0x1f, 0xf7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf8, 0x38, 0x38, 0x3f, 0xf3, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xe7, 0xf8, 0x38, 0x38, 0x3f, 0xe7, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xfc, 0x38, 0x38, 0x3f, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xfc, 0x38, 0x38, 0x3f, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x38, 0x30, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x01, 0x7e, 0x7c, 0x38, 0x30, 0x3e, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x02, 0x7f, 0x3c, 0x38, 0x70, 0x7c, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x04, 0x9f, 0x9d, 0xff, 0xf0, 0x79, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x07, 0x0f, 0xcf, 0xff, 0xfc, 0x73, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe7, 0xff, 0xff, 0xe7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x33, 0xf3, 0xff, 0xff, 0xcf, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xff, 0x9f, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0x3f, 0x14, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x7f, 0xfe, 0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x3f, 0xfc, 0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3f, 0x9f, 0xf9, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4f, 0xcf, 0xf3, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0xe7, 0xe7, 0xe1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf3, 0xcf, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0x9f, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0x3f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x27, 0xf4, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

void drawArrowUp(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    u8g2.drawVLine(x0 + i, y0 + size - i, 2 * i + 1);
  }
}

void drawArrowDown(int16_t x0, int16_t y0, int16_t size, uint16_t color) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    u8g2.drawHLine(x0 - i, y0 - i, 2 * i + 1);
  }
}

void drawBitmap(int16_t x, int16_t y, const unsigned char *bitmap, uint16_t width, uint16_t height) {
  for (int16_t j = 0; j < height; j++) 
  {
    for (int16_t i = 0; i < width; i++) 
    {
      uint8_t byte = pgm_read_byte(bitmap + (j * (width / 8)) + (i / 8));
      uint8_t bit = (byte >> (7 - (i % 8))) & 1;
      if (bit) 
      {
        u8g2.drawPixel(x + i, y + j);
      }
    }
  }
}

void setup() 
{
  Serial.begin(115200);

  // Adres I2C – U8g2 podaje się w formacie 8-bit (adres_7bit * 2)
  u8g2.setI2CAddress(0x3F * 2);

  u8g2.begin();

  // Często przy ST7567 warto dobrać kontrast (0–255)
  u8g2.setContrast(140);   // jeśli obraz jest zbyt jasny/ciemny – zmień np. 140–220
}

void loop() 
{

  u8g2.clearBuffer(); // Wyczyść bufor

  drawBitmap(0, 0, logo, 128, 64);

  u8g2.setFont(u8g2_font_ncenB08_tr); // Ustawienie czcionki

  drawArrowUp(5, 4, 5, 1);
  u8g2.drawStr(12, 12,"64px");

  drawArrowDown(9, 58, 5, 1);
  u8g2.drawStr(15, 58,"128px");

  u8g2.sendBuffer(); // Prześlij bufor do wyświetlacza

  delay(15000);

  u8g2.clearBuffer(); // Wyczyść bufor
  
  //Rysowanie linii i strzałek
  int x1 = SCREEN_WIDTH / 3;
  int y1 = SCREEN_HEIGHT * 2 / 3;
  
  // Pierwsza linia z strzałkami na końcach
  u8g2.drawLine(0, y1, SCREEN_WIDTH, y1);
  u8g2.drawLine(x1 - 5, 5, x1, 0);
  u8g2.drawLine(x1 + 5, 5, x1, 0);
  u8g2.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1);
  u8g2.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1);
  
  // Druga linia z strzałkami na końcach
  u8g2.drawLine(x1, SCREEN_HEIGHT, x1, 0);
  u8g2.drawLine(SCREEN_WIDTH - 6, y1 - 5, SCREEN_WIDTH - 1, y1);
  u8g2.drawLine(SCREEN_WIDTH - 6, y1 + 5, SCREEN_WIDTH - 1, y1);
  u8g2.drawLine(5, y1 - 5, 0, y1);
  u8g2.drawLine(5, y1 + 5, 0, y1);

  //Napis "64px" nad lewą strzałką pierwszej linii
  u8g2.drawStr(44, 16,"64px");
  
  // Napis "128px" po prawej stronie drugiej linii
  u8g2.drawStr(90, 39,"128px");

  u8g2.sendBuffer(); // Prześlij bufor do wyświetlacza
  delay(15000);
}
