/***************************************************
  ESP32 + HTU31D — przykład (I2C)

  Biblioteki (Menadżer bibliotek):
  - Adafruit HTU31D Library
  - Adafruit BusIO 
  - Adafruit Unified Sensor

  Połączenia (ESP32 klasyczny):
  VCC -> 3V3
  GND -> GND
  SDA -> GPIO21
  SCL -> GPIO22

****************************************************/

#include <Wire.h>
#include <Adafruit_Sensor.h>
#include "Adafruit_HTU31D.h"

#define I2C_SDA 21
#define I2C_SCL 22

Adafruit_HTU31D htu = Adafruit_HTU31D();
uint32_t timestamp;
bool heaterEnabled = false;

void setup() 
{
  Serial.begin(115200);

  // Start I2C na pinach ESP32
  Wire.begin(I2C_SDA, I2C_SCL);

  Serial.println("Adafruit HTU31D test (ESP32)");

  // Inicjalizacja sensora (domyślny adres 0x40)
  if (!htu.begin(0x40)) 
  {
    Serial.println("Couldn't find sensor!");
    while (1);
  }

  timestamp = millis();
}

void loop() {
  sensors_event_t humidity, temp;

  // Pobranie świeżych danych (biblioteka weryfikuje CRC)
  if (htu.getEvent(&humidity, &temp)) 
  {
    Serial.print("Temp: ");
    Serial.print(temp.temperature);
    Serial.println(" C");

    Serial.print("Humidity: ");
    Serial.print(humidity.relative_humidity);
    Serial.println(" % RH");
  } 
  else 
  {
    Serial.println("Read error (CRC/I2C). Check wiring/pull-ups.");
  }

  // Co 5 sekund przełącz grzałkę (anty-kondensacja)
  if ((millis() - timestamp) > 5000) 
  {
    heaterEnabled = !heaterEnabled;
    Serial.println(heaterEnabled ? "Turning on heater" : "Turning off heater");
    if (!htu.enableHeater(heaterEnabled)) 
    {
      Serial.println("Command failed");
    }
    timestamp = millis();
  }

  delay(1000);
}
