/*
  Przykład użycia czujnika BMP180 z ESP32
  Autor: [Sklep msalamon]
  Data: [08.2025]
  
  Opis:
  Ten kod pokazuje jak odczytać temperaturę i ciśnienie z czujnika BMP180
  
  Wymagania:
  - Moduł ESP32
  - Czujnik BMP180
  - Biblioteka: Adafruit BMP085/BMP180 Unified
    (W Arduino IDE: Szkic → Dołącz bibliotekę → Zarządzaj bibliotekami → "Adafruit BMP085 Unified")
  
  Połączenia (ESP32 ↔ BMP180):
  - VIN  → 3.3V 
  - GND  → GND
  - SCL  → GPIO 22 (domyślny pin SCL w ESP32)
  - SDA  → GPIO 21 (domyślny pin SDA w ESP32)
*/

#include <Wire.h>
#include <Adafruit_BMP085_U.h> // Biblioteka obsługująca BMP085 i BMP180

// Tworzymy obiekt czujnika
Adafruit_BMP085_Unified bmp = Adafruit_BMP085_Unified(10085);

void setup() 
{
  // Inicjalizacja portu szeregowego do komunikacji z komputerem
  // Używamy prędkości 115200 bps dla przesyłu danych
  Serial.begin(115200);
  Serial.println("BMP180 – Przykład odczytu danych");

  // Rozpoczęcie komunikacji z czujnikiem BMP180
  if (!bmp.begin()) 
  {
    // Jeżeli czujnik nie odpowiada, wyświetlamy komunikat o błędzie
    Serial.println("Nie znaleziono czujnika BMP180! Sprawdź połączenia.");
    while (1); // Zatrzymanie programu w pętli nieskończonej
  }
}

void loop() 
{
  // --- Odczyt temperatury ---
  float temp = 0;                   // Zmienna przechowująca temperaturę
  bmp.getTemperature(&temp);        // Odczyt temperatury w stopniach Celsjusza

  // --- Odczyt ciśnienia ---
  float cisnienie_Pa = 0;            // Zmienna w Pa (paskalach)
  bmp.getPressure(&cisnienie_Pa);    // Odczyt ciśnienia w Pa
  float cisnienie_hPa = cisnienie_Pa / 100.0; // Konwersja z Pa na hPa (hektopaskale)

  // --- Wyświetlanie danych ---
  Serial.print("Temperatura: ");
  Serial.print(temp, 2);             // Wyświetlanie temperatury z dokładnością do 2 miejsc po przecinku
  Serial.println(" *C");

  Serial.print("Ciśnienie:   ");
  Serial.print(cisnienie_hPa, 2);    // Wyświetlanie ciśnienia z dokładnością do 2 miejsc po przecinku
  Serial.println(" hPa");

  Serial.println("--------------------");

  // Opóźnienie 2 sekundy przed kolejnym odczytem
  delay(2000);
}