#include <Wire.h>
#include <BH1750.h>

BH1750 lightMeter;

void setup() 
{
  Serial.begin(115200);
  Wire.begin(21, 22); // SDA = 21, SCL = 22 dla ESP32

  if (lightMeter.begin(BH1750::CONTINUOUS_HIGH_RES_MODE)) 
  {
    Serial.println("BH1750 rozpoczął pracę poprawnie.");
  } 
  else 
  {
    Serial.println("Błąd inicjalizacji BH1750! Sprawdź połączenia.");
    while (1);
  }
}

void loop() 
{
  float lux = lightMeter.readLightLevel();
  Serial.print("Natężenie oświetlenia: ");
  Serial.print(lux);
  Serial.println(" lx");

  delay(1000); // odczyt co 1 sekundę
}
