/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "i2c.h"
#include "icache.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define ADS1115_ADDRESS        (0x48 << 1)
#define ADS1115_REG_CONVERSION 0x00
#define ADS1115_REG_CONFIG     0x01

// *************** PGA – Zakres pomiarowy ****************
#define ADS1115_PGA_6_144V     (0x00 << 9) // ±6.144 V (LSB = 187.5 μV)
#define ADS1115_PGA_4_096V     (0x01 << 9) // ±4.096 V (LSB = 125 μV)
#define ADS1115_PGA_2_048V     (0x02 << 9) // ±2.048 V (LSB = 62.5 μV)
#define ADS1115_PGA_1_024V     (0x03 << 9) // ±1.024 V (LSB = 31.25 μV)
#define ADS1115_PGA_0_512V     (0x04 << 9) // ±0.512 V (LSB = 15.625 μV)
#define ADS1115_PGA_0_256V     (0x05 << 9) // ±0.256 V (LSB = 7.8125 μV)

// *************** Data Rate – SPS ****************
#define ADS1115_DR_8SPS        (0x00 << 5)
#define ADS1115_DR_16SPS       (0x01 << 5)
#define ADS1115_DR_32SPS       (0x02 << 5)
#define ADS1115_DR_64SPS       (0x03 << 5)
#define ADS1115_DR_128SPS      (0x04 << 5)
#define ADS1115_DR_250SPS      (0x05 << 5)
#define ADS1115_DR_475SPS      (0x06 << 5)
#define ADS1115_DR_860SPS      (0x07 << 5)

// *************** Tryb pracy ****************
#define ADS1115_MODE_SINGLESHOT (0x01 << 8)
#define ADS1115_COMP_DISABLE    0x03

// *************** Kanały – single-ended ****************
#define ADS1115_CH_AIN0        0
#define ADS1115_CH_AIN1        1
#define ADS1115_CH_AIN2        2
#define ADS1115_CH_AIN3        3
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
float ads1115_lsb;             // przelicznik LSB na Volt
uint16_t ads1115_base_config;  // bazowa konfiguracja (PGA + SPS)
uint8_t ads1115_delay_ms;      // automatyczny czas konwersji
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */
void ADS1115_Init(uint16_t pga, uint16_t data_rate);
int16_t ADS1115_ReadRaw(uint8_t channel);
float ADS1115_ReadVoltage(uint8_t channel);
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void ADS1115_WriteConfig(uint16_t config)
{
    uint8_t data[3];
    data[0] = ADS1115_REG_CONFIG;
    data[1] = (uint8_t)(config >> 8);
    data[2] = (uint8_t)(config & 0xFF);
    HAL_I2C_Master_Transmit(&hi2c1, ADS1115_ADDRESS, data, 3, HAL_MAX_DELAY);
}

int16_t ADS1115_ReadConversion(void)
{
    uint8_t data[2];
    uint8_t reg = ADS1115_REG_CONVERSION;
    HAL_I2C_Master_Transmit(&hi2c1, ADS1115_ADDRESS, &reg, 1, HAL_MAX_DELAY);
    HAL_I2C_Master_Receive(&hi2c1, ADS1115_ADDRESS, data, 2, HAL_MAX_DELAY);
    return (int16_t)((data[0] << 8) | data[1]);
}

void ADS1115_Init(uint16_t pga, uint16_t data_rate)
{
    ads1115_base_config = 0;
    ads1115_base_config |= pga;
    ads1115_base_config |= ADS1115_MODE_SINGLESHOT;
    ads1115_base_config |= data_rate;
    ads1115_base_config |= ADS1115_COMP_DISABLE;

    // LSB zależne od PGA
    uint8_t pga_bits = (ads1115_base_config >> 9) & 0x07;
    switch (pga_bits)
    {
        case 0: ads1115_lsb = 0.0001875f; break;
        case 1: ads1115_lsb = 0.000125f; break;
        case 2: ads1115_lsb = 0.0000625f; break;
        case 3: ads1115_lsb = 0.00003125f; break;
        case 4: ads1115_lsb = 0.000015625f; break;
        case 5: ads1115_lsb = 0.0000078125f; break;
        default: ads1115_lsb = 0.0000625f; break;
    }

    // Automatyczny czas konwersji wg SPS
    uint8_t dr_bits = (data_rate >> 5) & 0x07;
    switch (dr_bits)
    {
        case 0: ads1115_delay_ms = 130; break;
        case 1: ads1115_delay_ms = 70;  break;
        case 2: ads1115_delay_ms = 35;  break;
        case 3: ads1115_delay_ms = 20;  break;
        case 4: ads1115_delay_ms = 10;  break;
        case 5: ads1115_delay_ms = 5;   break;
        case 6: ads1115_delay_ms = 3;   break;
        case 7: ads1115_delay_ms = 2;   break;
        default: ads1115_delay_ms = 10; break;
    }
}

int16_t ADS1115_ReadRaw(uint8_t channel)
{
    uint16_t config = ads1115_base_config | (1 << 15); // start konwersji

    switch (channel)
    {
        case ADS1115_CH_AIN0: config |= (0x04 << 12); break;
        case ADS1115_CH_AIN1: config |= (0x05 << 12); break;
        case ADS1115_CH_AIN2: config |= (0x06 << 12); break;
        case ADS1115_CH_AIN3: config |= (0x07 << 12); break;
        default: return 0;
    }

    ADS1115_WriteConfig(config);
    HAL_Delay(ads1115_delay_ms);

    return ADS1115_ReadConversion();
}

float ADS1115_ReadVoltage(uint8_t channel)
{
    return ADS1115_ReadRaw(channel) * ads1115_lsb;
}
/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_ICACHE_Init();
  MX_I2C1_Init();
  /* USER CODE BEGIN 2 */
  ADS1115_Init(ADS1115_PGA_4_096V, ADS1115_DR_128SPS); // ustaw PGA i SPS
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
	// Odczyt RAW
	int16_t raw0 = ADS1115_ReadRaw(ADS1115_CH_AIN0);
	int16_t raw1 = ADS1115_ReadRaw(ADS1115_CH_AIN1);
	int16_t raw2 = ADS1115_ReadRaw(ADS1115_CH_AIN2);
	int16_t raw3 = ADS1115_ReadRaw(ADS1115_CH_AIN3);

	// Odczyt w Voltach
	float v0 = ADS1115_ReadVoltage(ADS1115_CH_AIN0);
	float v1 = ADS1115_ReadVoltage(ADS1115_CH_AIN1);
	float v2 = ADS1115_ReadVoltage(ADS1115_CH_AIN2);
	float v3 = ADS1115_ReadVoltage(ADS1115_CH_AIN3);

	HAL_Delay(1000);
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE0);

  while(!__HAL_PWR_GET_FLAG(PWR_FLAG_VOSRDY)) {}

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_CSI;
  RCC_OscInitStruct.CSIState = RCC_CSI_ON;
  RCC_OscInitStruct.CSICalibrationValue = RCC_CSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLL1_SOURCE_CSI;
  RCC_OscInitStruct.PLL.PLLM = 1;
  RCC_OscInitStruct.PLL.PLLN = 125;
  RCC_OscInitStruct.PLL.PLLP = 2;
  RCC_OscInitStruct.PLL.PLLQ = 2;
  RCC_OscInitStruct.PLL.PLLR = 2;
  RCC_OscInitStruct.PLL.PLLRGE = RCC_PLL1_VCIRANGE_2;
  RCC_OscInitStruct.PLL.PLLVCOSEL = RCC_PLL1_VCORANGE_WIDE;
  RCC_OscInitStruct.PLL.PLLFRACN = 0;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2
                              |RCC_CLOCKTYPE_PCLK3;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB3CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure the programming delay
  */
  __HAL_FLASH_SET_PROGRAM_DELAY(FLASH_PROGRAMMING_DELAY_2);
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
