#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>

// Tworzymy obiekt czujnika BME280
Adafruit_BME280 bme;

// Interwał czasowy pomiarów (w milisekundach)
unsigned long delayTime = 2000;

void setup() 
{
  // Inicjalizacja komunikacji szeregowej
  Serial.begin(115200);
  Serial.println(F("Inicjalizacja czujnika BME280..."));

  // Inicjalizacja czujnika BME280 przez I2C (adres domyślny 0x76)
  if (!bme.begin(0x76)) 
  {
    Serial.println("Nie znaleziono czujnika BME280. Sprawdź połączenia!");
    while (1); // Zatrzymaj program, jeśli czujnik nie został wykryty
  }

  Serial.println("Czujnik BME280 gotowy do pracy.");
}

void loop() 
{
  // Odczyt temperatury w stopniach Celsjusza
  float temperature = bme.readTemperature();

  // Odczyt ciśnienia w hektopaskalach (hPa)
  float pressure = bme.readPressure() / 100.0F;

  // Odczyt wilgotności względnej (%)
  float humidity = bme.readHumidity();

  // Wyświetlanie danych na monitorze portu szeregowego
  Serial.print("Temperatura: ");
  Serial.print(temperature);
  Serial.println(" *C");

  Serial.print("Ciśnienie: ");
  Serial.print(pressure);
  Serial.println(" hPa");

  Serial.print("Wilgotność: ");
  Serial.print(humidity);
  Serial.println(" %");

  Serial.println("---------------------------");

  // Opóźnienie między kolejnymi pomiarami
  delay(delayTime);
}
