#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <Keypad.h>

// === LCD I2C ===
LiquidCrystal_I2C lcd(0x27, 16, 2);

// === Klawiatura 4x4 ===
const byte ROWS = 4;
const byte COLS = 4;

char keys[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

byte rowPins[ROWS] = {9, 8, 7, 6};
byte colPins[COLS] = {5, 4, 3, 2};

Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);

// === Kalkulator ===
String input = "";
char operation = 0;
long int firstNum = 0;
bool wynikGotowy = false;

void setup() 
{
  Serial.begin(115200);
  lcd.init();
  lcd.backlight();

  lcd.setCursor(0, 0);
  lcd.print("Kalkulator :)");
  delay(1000);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Wpisz liczbe:");
}

void loop() 
{
  char key = keypad.getKey();

  if (key) 
  {
    if (key >= '0' && key <= '9') 
    {
      if (wynikGotowy) {       // <-- sprawdzamy, czy wynik był wcześniej
        input = "";            // <-- czyścimy bufor
        lcd.clear();           // <-- czyścimy ekran
        lcd.setCursor(0, 0);
        lcd.print("Wpisz liczbe:");
        wynikGotowy = false;   // <-- resetujemy flagę
      }

      input += key;
      showInput();
    }
    else if (key == 'A') 
    {
      setOperation('+');
    }
    else if (key == 'B') 
    {
      setOperation('-');
    }
    else if (key == 'C') 
    {
      calculate();
    }
    else if (key == 'D') 
    {
      resetCalc();
    }
  }
}

void showInput() 
{
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Wpis: ");
  lcd.print(input);
}

void setOperation(char op) 
{
  if (input.length() > 0) 
  {
    firstNum = input.toInt();
    operation = op;
    input = "";

    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Operacja: ");
    lcd.print(operation);
    delay(800);
    lcd.clear();
    lcd.print("Wpisz druga:");
  }
}

void calculate() 
{
  if (input.length() > 0 && operation != 0) 
  {
    int secondNum = input.toInt();
    long int result = 0;

    if (operation == '+') 
    {
      result = firstNum + secondNum;
    }
    else if (operation == '-') 
    {
      result = firstNum - secondNum;
    }

    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Wynik:");
    lcd.setCursor(0, 1);
    lcd.print(firstNum);
    lcd.print(" ");
    lcd.print(operation);
    lcd.print(" ");
    lcd.print(secondNum);
    lcd.print(" = ");
    lcd.print(result);

    input = String(result);
    operation = 0;
    wynikGotowy = true;     // <--- ustawiamy flagę
  }
}

void resetCalc() 
{
  input = "";
  operation = 0;
  firstNum = 0;
  wynikGotowy = false;
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Wpisz liczbe:");
}
