#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <Adafruit_ST7789.h>

#define TFT_CS   15
#define TFT_DC   2
#define TFT_RST  4

Adafruit_ILI9341 tftILI9341 = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);
Adafruit_ST7789 tftST7789 = Adafruit_ST7789(TFT_CS, TFT_DC, TFT_RST);

const int PinILI9341 = 21;
const int PinST7789 = 22;  

int TFT_choice = 0;

void setup()
{
  Serial.begin(115200);
  pinMode(PinILI9341, INPUT); 
  pinMode(PinST7789, INPUT); 

  pinMode(15, OUTPUT);
  pinMode(5,  OUTPUT);

  digitalWrite(PinILI9341, LOW); 
  digitalWrite(PinST7789, LOW); 

  digitalWrite(15, HIGH);
  digitalWrite(5,  HIGH);

  int ILI9341 = digitalRead(PinILI9341);
  int ST7789 = digitalRead(PinST7789);

  if(ILI9341 == HIGH)
  {
    TFT_choice = 1;

    tftILI9341.begin();

    Serial.println("TFT ILI9341 Gotowy do pracy!");
    delay(100);
  }
  else if(ST7789 == HIGH)
  {
    TFT_choice = 2;

    tftST7789.init(240, 320);  
    tftST7789.setRotation(6);  
    tftST7789.invertDisplay(false);

    Serial.println("TFT7789 Gotowy do pracy!");
    delay(100);
  }
}

void TFT_ILI9341()
{
  for (int color = 0; color < 3; color++) 
  {
    uint16_t drawColor;

    if (color == 0) 
    {
      drawColor = ILI9341_GREEN;
      tftILI9341.setTextColor(ILI9341_BLACK);  // Czarny tekst na zielonym tle
    } 
    else if (color == 1) 
    {
      drawColor = ILI9341_BLUE;
      tftILI9341.setTextColor(ILI9341_BLACK);  // Czarny tekst na niebieskim tle
    } 
    else 
    {
      drawColor = ILI9341_RED;
      tftILI9341.setTextColor(ILI9341_BLACK);  // Czarny tekst na czerwonym tle
    }

    // Rysowanie prostokąta o wybranym kolorze
    tftILI9341.fillRect(0, 0, tftILI9341.width(), tftILI9341.height(), drawColor);

    tftILI9341.setTextSize(2);

    // Wyświetlenie informacji o kolorze
    tftILI9341.setCursor(10, 10);
    if (color == 0) 
    {
      tftILI9341.print("Kolor: Zielony");
    } 
    else if (color == 1) 
    {
      tftILI9341.print("Kolor: Niebieski");
    } 
    else 
    {
      tftILI9341.print("Kolor: Czerwony");
    }

    tftILI9341.setCursor(10, 30);
    tftILI9341.print("Kontroler ILI9341");

    delay(5000);  // Przerwa 5 sekund między kolorami
    tftILI9341.fillScreen(ILI9341_BLACK);  // Wyczyszczenie ekranu
  }
}

void TFT_ST7789()
{
  for (int color = 0; color < 3; color++) 
  {
    uint16_t drawColor;

    if (color == 0) 
    {
      drawColor = ST77XX_GREEN;
      tftST7789.setTextColor(ST77XX_BLACK);  // Czarny tekst na zielonym tle
    } 
    else if (color == 1) 
    {
      drawColor = ST77XX_BLUE;
      tftST7789.setTextColor(ST77XX_BLACK);  // Czarny tekst na niebieskim tle
    } 
    else 
    {
      drawColor = ST77XX_RED;
      tftST7789.setTextColor(ST77XX_BLACK);  // Czarny tekst na czerwonym tle
    }

    // Rysowanie prostokąta o wybranym kolorze
    tftST7789.fillRect(0, 0, tftST7789.width(), tftST7789.height(), drawColor);

    tftST7789.setTextSize(2);

    // Wyświetlenie informacji o kolorze
    tftST7789.setCursor(10, 10);
    if (color == 0) 
    {
      tftST7789.print("Kolor: Zielony");
    } 
    else if (color == 1) 
    {
      tftST7789.print("Kolor: Niebieski");
    } 
    else 
    {
      tftST7789.print("Kolor: Czerwony");
    }

    tftST7789.setCursor(10, 30);
    tftST7789.print("Kontroler ST7789");

    delay(5000);  // Przerwa 5 sekund między kolorami
    tftST7789.fillScreen(ST77XX_BLACK);  // Wyczyszczenie ekranu
  }
}

void loop() 
{
  if(TFT_choice == 1)
  {
    TFT_ILI9341();
  }
  else if(TFT_choice == 2)
  {
    TFT_ST7789();
  }
  else
  {
    Serial.println(TFT_choice);
    Serial.println("Nie podpiołeś zworki!!!");
    delay(5000);
  }
}


