/*
  ============================== ADS1115 + ESP32 – Surowy odczyt (RAW) ==============================

  📌 Ten przykład pokazuje odczyt surowych wartości (RAW) z każdego z 4 kanałów ADS1115 (A0–A3).
  📌 Brak przeliczania na napięcie – tylko wartości 16-bitowe z ADC.

  🔧 Połączenia (ESP32 ↔ ADS1115):
     VDD  -> 3.3V (lub 5V jeśli poziomy logiczne pozwalają)
     GND  -> GND
     SDA  -> GPIO21
     SCL  -> GPIO22

  🧠 Adres I2C ADS1115 – zależy od połączenia pinu ADDR:
    - GND         → 0x48  (domyślnie)
    - VDD         → 0x49
    - SDA         → 0x4A
    - SCL         → 0x4B

  📐 Odczytywane wartości: liczby całkowite (int16_t), zakres:
    - 0 do 32767  (w trybie single-ended)

  ===========================================================================================
*/

#include <Wire.h>
#include <Adafruit_ADS1X15.h>

Adafruit_ADS1115 ads; // Obiekt ADS1115

// ========================
// Wybierz adres I2C – odkomentuj TYLKO jeden:
// ========================

#define ADS_I2C_ADDRESS 0x48   // ADDR = GND (domyślnie)
// #define ADS_I2C_ADDRESS 0x49   // ADDR = VDD
// #define ADS_I2C_ADDRESS 0x4A   // ADDR = SDA
// #define ADS_I2C_ADDRESS 0x4B   // ADDR = SCL

// ========================
// Wybierz GAIN – odkomentuj TYLKO jeden:
// ========================

// #define ADS_GAIN_SETTING GAIN_TWOTHIRDS // ±6.144V
#define ADS_GAIN_SETTING GAIN_ONE       // ±4.096V
// #define ADS_GAIN_SETTING GAIN_TWO       // ±2.048V
// #define ADS_GAIN_SETTING GAIN_FOUR      // ±1.024V
// #define ADS_GAIN_SETTING GAIN_EIGHT     // ±0.512V
// #define ADS_GAIN_SETTING GAIN_SIXTEEN   // ±0.256V

void setup() 
{
  Serial.begin(115200);
  delay(100);

  // Inicjalizacja I2C (ESP32: SDA=21, SCL=22)
  Wire.begin(21, 22);

  if (!ads.begin(ADS_I2C_ADDRESS)) 
  {
    Serial.print("Nie wykryto ADS1115 pod adresem 0x");
    Serial.println(ADS_I2C_ADDRESS, HEX);
    while (1);
  }

  ads.setGain(ADS_GAIN_SETTING);

  Serial.print("ADS1115 OK na adresie 0x");
  Serial.println(ADS_I2C_ADDRESS, HEX);
  Serial.println("Start odczytu RAW z kanałów A0–A3");
}

void loop() 
{
  // Surowe odczyty z kanałów A0–A3
  int16_t raw0 = ads.readADC_SingleEnded(0);
  int16_t raw1 = ads.readADC_SingleEnded(1);
  int16_t raw2 = ads.readADC_SingleEnded(2);
  int16_t raw3 = ads.readADC_SingleEnded(3);

  // Wyświetlenie wyników RAW
  Serial.print("A0: "); Serial.print(raw0); Serial.print("\t");
  Serial.print("A1: "); Serial.print(raw1); Serial.print("\t");
  Serial.print("A2: "); Serial.print(raw2); Serial.print("\t");
  Serial.print("A3: "); Serial.println(raw3);

  delay(1000); // 1 odczyt na sekundę
}
