#include <GxEPD2_BW.h>
#include <Fonts/FreeMonoBold9pt7b.h>
#include <SPI.h>

// NodeMCU ESP8266 pinout dla GDEM0213B74

// VCC   ->  3.3V
// GND   ->  GND
// SDI   ->  D7 (GPIO13 / MOSI)
// SCLK  ->  D5 (GPIO14 / SCK)
// CS    ->  D4 (GPIO2)
// D/C   ->  D2 (GPIO4)
// RESET ->  D1 (GPIO5)
// BUSY  ->  D0 (GPIO16)

GxEPD2_BW<GxEPD2_213_B74, GxEPD2_213_B74::HEIGHT> display(GxEPD2_213_B74(/*CS=D4*/ 2, /*DC=D2*/ 4, /*RST=D1*/ 5, /*BUSY=D0*/ 16));

void setup()
{
  display.init();

  display.setRotation(3);
  display.setFont(&FreeMonoBold9pt7b);
  display.setTextColor(GxEPD_BLACK);
  display.setFullWindow();

  display.firstPage();
  do
  {
    display.fillScreen(GxEPD_WHITE);
    display.setCursor(10, 30);
    display.println("GDEM0213B74");
  } while (display.nextPage());
}

void loop()
{
}
