#include <GxEPD2_BW.h>
#include <Fonts/FreeMonoBold9pt7b.h>

//ESP32 PINOUT

//VCC   ->  3.3V
//GND   ->  GND
//SDI   ->  23
//SCLK  ->  18
//CS    ->  5
//D/C   ->  17
//RESET ->  16
//BUSY  ->  4

GxEPD2_BW<GxEPD2_213_B74, GxEPD2_213_B74::HEIGHT> display(GxEPD2_213_B74(/*CS=*/5, /*DC=*/17, /*RESET=*/16, /*BUSY=*/4));

void setup() 
{
  Serial.begin(115200);
  display.init();

  display.setRotation(3);
  display.setFont(&FreeMonoBold9pt7b);
  display.setTextColor(GxEPD_BLACK);
  display.setFullWindow();

  display.firstPage();
  do 
  {
    display.fillScreen(GxEPD_WHITE);
    display.setCursor(10, 30);
    display.println("GDEM0213B74");
  } while (display.nextPage());
}

void loop() 
{
}
