#include <Wire.h>
#include <U8g2lib.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

#define OLED_RESET     -1 // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32

U8G2_SSD1309_128X64_NONAME0_F_HW_I2C display(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);

// 'logo', 128x64px
const unsigned char logo [] PROGMEM = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x03, 0xa0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xfe, 0x9f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfd, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3f, 0x7e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0x1f, 0xfc, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x8f, 0xf8, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xc7, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf1, 0xe3, 0xe3, 0xc7, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x20, 0xfb, 0xf1, 0xc7, 0x6f, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfe, 0xf8, 0x8f, 0x3f, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7e, 0xfc, 0x1f, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x3f, 0xfe, 0x3f, 0xfe, 0x18, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x9e, 0x1f, 0xff, 0x7f, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x8f, 0xff, 0xff, 0xf8, 0x37, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xc7, 0xff, 0xff, 0xf1, 0x1b, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x40, 0xf8, 0xe3, 0xff, 0xff, 0xe3, 0x0f, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xe0, 0xf8, 0xf1, 0xff, 0xff, 0xc7, 0x8f, 0x03, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xa0, 0xfd, 0x18, 0xfc, 0x07, 0x8e, 0xff, 0x02, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x60, 0x7f, 0x0c, 0x1c, 0x03, 0x1e, 0x3f, 0x03, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x0e, 0x04, 0x00, 0x3c, 0xfe, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x0f, 0x00, 0x18, 0x7c, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0x8f, 0x0f, 0x00, 0x1c, 0xfc, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0xc7, 0x1f, 0x1c, 0x1c, 0xfc, 0xf1, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0xe3, 0x1f, 0x1c, 0x1c, 0xfc, 0xe3, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0xf1, 0x1f, 0x1c, 0x1c, 0xfc, 0xc7, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0xf1, 0x1f, 0x1c, 0x1c, 0xfc, 0xc7, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0xe3, 0x1f, 0x1c, 0x1e, 0xfe, 0xe3, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0xc7, 0x1f, 0x1c, 0x0e, 0xfe, 0xf1, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0x8f, 0x1f, 0x1c, 0x0e, 0xfe, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x1f, 0x0c, 0x0e, 0x7e, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x1e, 0x0c, 0x0e, 0x3e, 0xfe, 0x01, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x60, 0x7f, 0x1c, 0x0c, 0x0e, 0x1e, 0x7f, 0x03, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xa0, 0xfd, 0xf8, 0xff, 0x07, 0x8e, 0xdf, 0x02, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0xe0, 0xf8, 0xf1, 0xff, 0x0f, 0xc7, 0x8f, 0x03, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xe3, 0xff, 0xff, 0xe3, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xee, 0xc7, 0xff, 0xff, 0xf1, 0x1b, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xf2, 0x8f, 0xff, 0xff, 0xf8, 0x37, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x9e, 0x1f, 0xff, 0x7f, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x3f, 0xfe, 0x3f, 0xfe, 0x18, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7e, 0xfc, 0x1f, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfe, 0xf8, 0x8f, 0x3f, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfb, 0xf1, 0xc7, 0x6f, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf1, 0xe3, 0xe3, 0xc7, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xc7, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x8f, 0xf8, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0x1f, 0xfc, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3f, 0x7e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x7f, 0x7f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf6, 0xbf, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xa0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

void drawArrowUp(int16_t x0, int16_t y0, int16_t size) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawVLine(x0 + i, y0 + size - i, 2 * i + 1);
  }
}

void drawArrowDown(int16_t x0, int16_t y0, int16_t size) 
{
  for (int16_t i = 0; i < size; i++) 
  {
    display.drawHLine(x0 - i, y0 - i, 2 * i + 1);
  }
}

void setup() 
{
  display.begin();
}

void loop() 
{
  display.clearBuffer();  // Wyczyść bufor

  // Rysuj bitmapę
  display.drawXBMP(0, 0, 128, 64, logo);

  // Strzałka w górę
  drawArrowUp(5, 4, 5);

  display.setFont(u8g2_font_6x10_tf);  // Wybór czcionki
  display.setCursor(12, 13);           // Pozycja tekstu
  display.print("64px");

  // Strzałka w dół
  drawArrowDown(9, 58, 5);

  display.setCursor(15, 58);           // Pozycja tekstu
  display.print("128px");

  display.sendBuffer();                
  delay(15000);
  display.clearBuffer(); // zamiast clearDisplay()

  int x1 = SCREEN_WIDTH / 3; 
  int y1 = SCREEN_HEIGHT * 2 / 3;

  // Pierwsza pozioma linia
  display.drawLine(0, y1, SCREEN_WIDTH, y1);

  // Górna strzałka na środku
  display.drawLine(x1 - 5, 5, x1, 0); 
  display.drawLine(x1 + 5, 5, x1, 0); 

  // Dolna strzałka na środku
  display.drawLine(x1 - 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1);
  display.drawLine(x1 + 5, SCREEN_HEIGHT - 6, x1, SCREEN_HEIGHT - 1);

  // Druga linia pionowa
  display.drawLine(x1, SCREEN_HEIGHT, x1, 0);

  // Prawa strzałka
  display.drawLine(SCREEN_WIDTH - 6, y1 - 5, SCREEN_WIDTH - 1, y1);
  display.drawLine(SCREEN_WIDTH - 6, y1 + 5, SCREEN_WIDTH - 1, y1);

  // Lewa strzałka
  display.drawLine(5, y1 - 5, 0, y1);
  display.drawLine(5, y1 + 5, 0, y1);

  // Teksty
  display.setFont(u8g2_font_6x10_tr);
  display.drawStr(45, 15, "64px");
  display.drawStr(92, 39, "128px");

  display.sendBuffer();
  
  delay(15000);
  display.clearBuffer();
  display.sendBuffer();
}
