#include <SPI.h>

// Definicje pinów dla ESP32 (Dostosuj do swojego modułu)
#define PIN_MISO 19  
#define PIN_MOSI 23   
#define PIN_SCK  18   
#define PIN_CS   5    

// Komendy SPI dla W25Q128
#define CMD_WRITE_ENABLE  0x06
#define CMD_SECTOR_ERASE  0x20
#define CMD_PAGE_PROGRAM  0x02
#define CMD_READ_DATA     0x03
#define SECTOR_SIZE       4096  // 4KB

SPIClass spi = SPIClass(VSPI);

void sendCommand(uint8_t cmd) 
{
  digitalWrite(PIN_CS, LOW);
  spi.transfer(cmd);
  digitalWrite(PIN_CS, HIGH);
}

void eraseSector(uint32_t address) 
{
  sendCommand(CMD_WRITE_ENABLE);
  digitalWrite(PIN_CS, LOW);
  spi.transfer(CMD_SECTOR_ERASE);
  spi.transfer((address >> 16) & 0xFF);
  spi.transfer((address >> 8) & 0xFF);
  spi.transfer(address & 0xFF);
  digitalWrite(PIN_CS, HIGH);

  delay(100);
}

void writeData(uint32_t address, const char* data, size_t len)
{
  sendCommand(CMD_WRITE_ENABLE);
  digitalWrite(PIN_CS, LOW);
  spi.transfer(CMD_PAGE_PROGRAM);
  spi.transfer((address >> 16) & 0xFF);
  spi.transfer((address >> 8) & 0xFF);
  spi.transfer(address & 0xFF);

  for (size_t i = 0; i < len; i++) 
  {
    spi.transfer(data[i]);
  }

  digitalWrite(PIN_CS, HIGH);
  delay(10); // Krótka pauza po zapisie
}

void readData(uint32_t address, char* buffer, size_t len) 
{
  digitalWrite(PIN_CS, LOW);
  spi.transfer(CMD_READ_DATA);
  spi.transfer((address >> 16) & 0xFF);
  spi.transfer((address >> 8) & 0xFF);
  spi.transfer(address & 0xFF);

  for (size_t i = 0; i < len; i++) 
  {
    buffer[i] = spi.transfer(0xFF);
  }

  digitalWrite(PIN_CS, HIGH);
}

void setup() 
{
  Serial.begin(115200);
  spi.begin(PIN_SCK, PIN_MISO, PIN_MOSI, PIN_CS);
  pinMode(PIN_CS, OUTPUT);
  digitalWrite(PIN_CS, HIGH);

  Serial.println("Inicjalizacja SPI Flash W25Q128...");

  uint32_t sectorAddress = 0x000000; // Adres sektora do wyczyszczenia
  eraseSector(sectorAddress);
  Serial.println("Sektor pamięci wyczyszczony.");

  const char* text = "Hello ESP32 + W25Q128!";
  writeData(sectorAddress, text, strlen(text));
  Serial.println("Dane zapisane w pamięci.");

  char readBuffer[32] = {0};
  readData(sectorAddress, readBuffer, strlen(text));

  Serial.print("Odczytane dane: ");
  Serial.println(readBuffer);
}

void loop() 
{
  // Pętla nie jest potrzebna w tym przykładzie
}
